<?php
/**
 * Zoom Meeting types.
 *
 * @since 2.5.19
 * @package Masteriyo\Enums
 */

namespace Masteriyo\Addons\Zoom\Enums;

use Masteriyo\Enums\PostStatus;

defined( 'ABSPATH' ) || exit;

/**
 * Zoom Meeting Status enum class.
 *
 * @since 2.5.19
 */
class ZoomMeetingStatus extends PostStatus {
	/**
	 * Zoom all Meeting type.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const ALL = 'all';

		/**
	 * Zoom scheduled Meeting type.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const UPCOMING = 'upcoming';

	/**
	 * Zoom Expired Meeting type.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const EXPIRED = 'expired';

	/**
	 * Zoom Active Meeting.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const ACTIVE = 'active';

	/**
	 * Return all Zoom Meeting types.
	 *
	 * @since 2.5.19
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters Zoom Meeting Status list.
			 *
			 * @since 2.5.19
			 *
			 * @param string[] $status Zoom Meeting status.
			 */

			apply_filters(
				'masteriyo_pro_zoom_meeting_status',
				array_merge(
					parent::all(),
					array(
						self::ALL,
						self::UPCOMING,
						self::ACTIVE,
						self::EXPIRED,
					)
				)
			)
		);
	}
}
