<?php
/**
 * Zoom Meeting types.
 *
 * @since 2.5.19
 * @package Masteriyo\Enums
 */

namespace Masteriyo\Addons\Zoom\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * Zoom Meeting type enum class.
 *
 * @since 2.5.19
 */
class ZoomMeetingType {
	/**
	 * Zoom instant meeting type.
	 *
	 * @since 2.5.19
	 * @var integer
	 */
	const INSTANT = '1';

	/**
	 * Zoom scheduled meeting type.
	 *
	 * @since 2.5.19
	 * @var integer
	 */
	const SCHEDULED = '2';

	/**
	 * Zoom recurring not fixed meeting type.
	 *
	 * @since 2.5.19
	 * @var integer
	 */
	const NOT_FIXED_RECURRING = '3';

	/**
	 * Zoom recurring fixed meeting type.
	 *
	 * @since 2.5.19
	 * @var integer
	 */
	const FIXED_RECURRING = '8';

	/**
	 * Return all Zoom Meeting types.
	 *
	 * @since 2.5.19
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters Zoom Meeting type list.
			 *
			 * @since 2.5.19
			 *
			 * @param integer[] $types Zoom Meeting types.
			 */

			apply_filters(
				'masteriyo_pro_zoom_meeting_types',
				array(
					self::INSTANT,
					self::SCHEDULED,
					self::NOT_FIXED_RECURRING,
					self::FIXED_RECURRING,
				)
			)
		);
	}
}
