<?php
/**
 * Zoom Recording type enums.
 *
 * @since 2.5.19
 * @package Masteriyo\Enums
 */

namespace Masteriyo\Addons\Zoom\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * Zoom Recording type enum class.
 *
 * @since 2.5.19
 */
class ZoomRecordingType {
	/**
	 * Zoom Recording none type.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const NONE = 'none';

	/**
	 * Zoom Recording local type.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const LOCAL = 'local';

	/**
	 * Zoom Recording cloud type.
	 *
	 * @since 2.5.19
	 * @var string
	 */
	const CLOUD = 'cloud';

	/**
	 * Return all Zoom Recording types.
	 *
	 * @since 2.5.19
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters Zoom Recording type list.
			 *
			 * @since 2.5.19
			 *
			 * @param string[] $types Zoom Recording types.
			 */

			apply_filters(
				'masteriyo_pro_zoom_recording_types',
				array(
					self::NONE,
					self::LOCAL,
					self::CLOUD,
				)
			)
		);
	}
}
