<?php
/**
 * Class for parameter-based zoom query.
 *
 * @package  Masteriyo\Addons\Zoom
 * @version 2.6.5
 * @since   2.6.5
 */

namespace Masteriyo\Addons\Zoom\Query;

use Masteriyo\Abstracts\ObjectQuery;
use Masteriyo\Addons\Zoom\Enums\ZoomMeetingStatus;
use Masteriyo\PostType\PostType;

defined( 'ABSPATH' ) || exit;

/**
 * Zoom query class.
 */
class ZoomQuery extends ObjectQuery {

	/**
	 * Valid query vars for zoom.
	 *
	 * @since 2.6.5
	 *
	 * @return array
	 */
	protected function get_default_query_vars() {
		return array_merge(
			parent::get_default_query_vars(),
			array(
				'type'        => PostType::ZOOM,
				'status'      => array( ZoomMeetingStatus::UPCOMING, ZoomMeetingStatus::ACTIVE, ZoomMeetingStatus::EXPIRED ),
				'include'     => array(),
				'created_at'  => '',
				'modified_at' => '',
				'course'      => array(),
			)
		);
	}

	/**
	 * Get zoom matching the current query vars.
	 *
	 * @since 2.6.5
	 *
	 * @return  object Object.
	 */
	public function get_zooms() {
		/**
		 * Filters zoom object query args.
		 *
		 * @since 2.6.5
		 *
		 * @param array $query_args The object query args.
		 */
		$args = apply_filters( 'masteriyo_zoom_object_query_args', $this->get_query_vars() );

		$results = masteriyo( 'zoom.store' )->query( $args );

		/**
		 * Filters zoom object query results.
		 *
		 * @since 2.6.5
		 *
		 * @param  \Masteriyo\Addons\Zoom\Models\Zoom[] $results The query results.
		 * @param array $query_args The object query args.
		 */
		return apply_filters( 'masteriyo_zoom_object_query', $results, $args );
	}
}
