<?php
/**
 * Zoom Meeting resource handler class.
 *
 * @since 2.8.3
 */

namespace Masteriyo\Addons\Zoom\Resources;

use Masteriyo\Helper\Utils;
use Masteriyo\Resources\CourseResource;
use Masteriyo\Resources\UserResource;

defined( 'ABSPATH' ) || exit;

/**
 * Zoom Meeting resource handler class.
 *
 * @since 2.8.3
 */
class ZoomMeetingResource {


	/**
	 * Transform the resource into an array.
	 *
	 * @since 2.8.3
	 *
	 * @param \Masteriyo\Addons\Zoom\Models\Zoom $zoom Zoom object.
	 * @param string $context What the value is for. Valid values are view and edit.
	 *
	 * @return array
	 */
	public static function to_array( $zoom, $context = 'view' ) {

		$course = masteriyo_get_course( $zoom->get_course_id() );
		$user   = masteriyo_get_user( $zoom->get_author_id( $context ) );

		$data = array(
			'name'               => $zoom->get_name(),
			'description'        => $zoom->get_description(),
			'password'           => $zoom->get_password(),
			'status'             => $zoom->get_status(),
			'author_id'          => $zoom->get_author_id(),
			'course_id'          => $zoom->get_course_id(),
			'menu_order'         => $zoom->get_menu_order(),
			'parent_id'          => $zoom->get_parent_id(),
			'duration'           => $zoom->get_duration(),
			'join_before_host'   => $zoom->get_join_before_host(),
			'focus_mode'         => $zoom->get_focus_mode(),
			'time_zone'          => $zoom->get_time_zone(),
			'mute_upon_entry'    => $zoom->get_mute_upon_entry(),
			'participant_video'  => $zoom->get_participant_video(),
			'record'             => $zoom->get_record(),
			'close_registration' => $zoom->get_close_registration(),
			'created_at'         => masteriyo_rest_prepare_date_response( $zoom->get_created_at() ),
			'modified_at'        => masteriyo_rest_prepare_date_response( $zoom->get_modified_at() ),
			'meeting_id'         => $zoom->get_meeting_id(),
			'start_url'          => $zoom->get_start_url(),
			'expires_at'         => masteriyo_rest_prepare_date_response( $zoom->get_expires_at() ),
			'starts_at'          => masteriyo_rest_prepare_date_response( $zoom->get_starts_at() ),
			'join_url'           => $zoom->get_join_url(),
			'host_video'         => $zoom->get_host_video(),
			'type'               => $zoom->get_type(),
			'course'             => CourseResource::to_array( $course ),
			'user'               => UserResource::to_array( $user ),
		);

		/**
		 * Filter zoom data array resource.
		 *
		 * @since 2.8.3
		 *
		 * @param array $data Course data.
		 * @param \Masteriyo\Models\Course $course Course object.
		 * @param string $context What the value is for. Valid values are view and edit.
		 */
		return apply_filters( 'masteriyo_zoom_resource_array', $data, $zoom, $context );
	}

	/**
	 * Get taxonomy terms if a course.
	 *
	 * @since 2.8.3
	 *
	 * @param \Masteriyo\Addons\Zoom\Models\Zoom $zoom Zoom object.
	 * @param string $taxonomy Taxonomy slug.
	 *
	 * @return array
	 */
	protected static function get_taxonomy_terms( $order, $taxonomy = 'cat' ) {
		$terms = Utils::get_object_terms( $order->get_id(), 'order_' . $taxonomy );

		$terms = array_map(
			function ( $term ) {
				return array(
					'id'   => $term->term_id,
					'name' => $term->name,
					'slug' => $term->slug,
				);
			},
			$terms
		);

		$terms = 'difficulty' === $taxonomy ? array_shift( $terms ) : $terms;

		return $terms;
	}
}
