<?php
/**
 * Calling codes.
 *
 * Returns an array of calling codes.
 *
 * @package Masteriyo\i18n
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'learning-management-system' ),
		'BLU' => __( 'Benguela', 'learning-management-system' ),
		'BIE' => __( 'Bié', 'learning-management-system' ),
		'CAB' => __( 'Cabinda', 'learning-management-system' ),
		'CNN' => __( 'Cunene', 'learning-management-system' ),
		'HUA' => __( 'Huambo', 'learning-management-system' ),
		'HUI' => __( 'Huíla', 'learning-management-system' ),
		'CCU' => __( 'Kuando Kubango', 'learning-management-system' ),
		'CNO' => __( 'Kwanza-Norte', 'learning-management-system' ),
		'CUS' => __( 'Kwanza-Sul', 'learning-management-system' ),
		'LUA' => __( 'Luanda', 'learning-management-system' ),
		'LNO' => __( 'Lunda-Norte', 'learning-management-system' ),
		'LSU' => __( 'Lunda-Sul', 'learning-management-system' ),
		'MAL' => __( 'Malanje', 'learning-management-system' ),
		'MOX' => __( 'Moxico', 'learning-management-system' ),
		'NAM' => __( 'Namibe', 'learning-management-system' ),
		'UIG' => __( 'Uíge', 'learning-management-system' ),
		'ZAI' => __( 'Zaire', 'learning-management-system' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'learning-management-system' ),
		'B' => __( 'Buenos Aires', 'learning-management-system' ),
		'K' => __( 'Catamarca', 'learning-management-system' ),
		'H' => __( 'Chaco', 'learning-management-system' ),
		'U' => __( 'Chubut', 'learning-management-system' ),
		'X' => __( 'Córdoba', 'learning-management-system' ),
		'W' => __( 'Corrientes', 'learning-management-system' ),
		'E' => __( 'Entre Ríos', 'learning-management-system' ),
		'P' => __( 'Formosa', 'learning-management-system' ),
		'Y' => __( 'Jujuy', 'learning-management-system' ),
		'L' => __( 'La Pampa', 'learning-management-system' ),
		'F' => __( 'La Rioja', 'learning-management-system' ),
		'M' => __( 'Mendoza', 'learning-management-system' ),
		'N' => __( 'Misiones', 'learning-management-system' ),
		'Q' => __( 'Neuquén', 'learning-management-system' ),
		'R' => __( 'Río Negro', 'learning-management-system' ),
		'A' => __( 'Salta', 'learning-management-system' ),
		'J' => __( 'San Juan', 'learning-management-system' ),
		'D' => __( 'San Luis', 'learning-management-system' ),
		'Z' => __( 'Santa Cruz', 'learning-management-system' ),
		'S' => __( 'Santa Fe', 'learning-management-system' ),
		'G' => __( 'Santiago del Estero', 'learning-management-system' ),
		'V' => __( 'Tierra del Fuego', 'learning-management-system' ),
		'T' => __( 'Tucumán', 'learning-management-system' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'learning-management-system' ),
		'NSW' => __( 'New South Wales', 'learning-management-system' ),
		'NT'  => __( 'Northern Territory', 'learning-management-system' ),
		'QLD' => __( 'Queensland', 'learning-management-system' ),
		'SA'  => __( 'South Australia', 'learning-management-system' ),
		'TAS' => __( 'Tasmania', 'learning-management-system' ),
		'VIC' => __( 'Victoria', 'learning-management-system' ),
		'WA'  => __( 'Western Australia', 'learning-management-system' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'learning-management-system' ),
		'BD-01' => __( 'Bandarban', 'learning-management-system' ),
		'BD-02' => __( 'Barguna', 'learning-management-system' ),
		'BD-06' => __( 'Barishal', 'learning-management-system' ),
		'BD-07' => __( 'Bhola', 'learning-management-system' ),
		'BD-03' => __( 'Bogura', 'learning-management-system' ),
		'BD-04' => __( 'Brahmanbaria', 'learning-management-system' ),
		'BD-09' => __( 'Chandpur', 'learning-management-system' ),
		'BD-10' => __( 'Chattogram', 'learning-management-system' ),
		'BD-12' => __( 'Chuadanga', 'learning-management-system' ),
		'BD-11' => __( "Cox's Bazar", 'learning-management-system' ),
		'BD-08' => __( 'Cumilla', 'learning-management-system' ),
		'BD-13' => __( 'Dhaka', 'learning-management-system' ),
		'BD-14' => __( 'Dinajpur', 'learning-management-system' ),
		'BD-15' => __( 'Faridpur ', 'learning-management-system' ),
		'BD-16' => __( 'Feni', 'learning-management-system' ),
		'BD-19' => __( 'Gaibandha', 'learning-management-system' ),
		'BD-18' => __( 'Gazipur', 'learning-management-system' ),
		'BD-17' => __( 'Gopalganj', 'learning-management-system' ),
		'BD-20' => __( 'Habiganj', 'learning-management-system' ),
		'BD-21' => __( 'Jamalpur', 'learning-management-system' ),
		'BD-22' => __( 'Jashore', 'learning-management-system' ),
		'BD-25' => __( 'Jhalokati', 'learning-management-system' ),
		'BD-23' => __( 'Jhenaidah', 'learning-management-system' ),
		'BD-24' => __( 'Joypurhat', 'learning-management-system' ),
		'BD-29' => __( 'Khagrachhari', 'learning-management-system' ),
		'BD-27' => __( 'Khulna', 'learning-management-system' ),
		'BD-26' => __( 'Kishoreganj', 'learning-management-system' ),
		'BD-28' => __( 'Kurigram', 'learning-management-system' ),
		'BD-30' => __( 'Kushtia', 'learning-management-system' ),
		'BD-31' => __( 'Lakshmipur', 'learning-management-system' ),
		'BD-32' => __( 'Lalmonirhat', 'learning-management-system' ),
		'BD-36' => __( 'Madaripur', 'learning-management-system' ),
		'BD-37' => __( 'Magura', 'learning-management-system' ),
		'BD-33' => __( 'Manikganj ', 'learning-management-system' ),
		'BD-39' => __( 'Meherpur', 'learning-management-system' ),
		'BD-38' => __( 'Moulvibazar', 'learning-management-system' ),
		'BD-35' => __( 'Munshiganj', 'learning-management-system' ),
		'BD-34' => __( 'Mymensingh', 'learning-management-system' ),
		'BD-48' => __( 'Naogaon', 'learning-management-system' ),
		'BD-43' => __( 'Narail', 'learning-management-system' ),
		'BD-40' => __( 'Narayanganj', 'learning-management-system' ),
		'BD-42' => __( 'Narsingdi', 'learning-management-system' ),
		'BD-44' => __( 'Natore', 'learning-management-system' ),
		'BD-45' => __( 'Nawabganj', 'learning-management-system' ),
		'BD-41' => __( 'Netrakona', 'learning-management-system' ),
		'BD-46' => __( 'Nilphamari', 'learning-management-system' ),
		'BD-47' => __( 'Noakhali', 'learning-management-system' ),
		'BD-49' => __( 'Pabna', 'learning-management-system' ),
		'BD-52' => __( 'Panchagarh', 'learning-management-system' ),
		'BD-51' => __( 'Patuakhali', 'learning-management-system' ),
		'BD-50' => __( 'Pirojpur', 'learning-management-system' ),
		'BD-53' => __( 'Rajbari', 'learning-management-system' ),
		'BD-54' => __( 'Rajshahi', 'learning-management-system' ),
		'BD-56' => __( 'Rangamati', 'learning-management-system' ),
		'BD-55' => __( 'Rangpur', 'learning-management-system' ),
		'BD-58' => __( 'Satkhira', 'learning-management-system' ),
		'BD-62' => __( 'Shariatpur', 'learning-management-system' ),
		'BD-57' => __( 'Sherpur', 'learning-management-system' ),
		'BD-59' => __( 'Sirajganj', 'learning-management-system' ),
		'BD-61' => __( 'Sunamganj', 'learning-management-system' ),
		'BD-60' => __( 'Sylhet', 'learning-management-system' ),
		'BD-63' => __( 'Tangail', 'learning-management-system' ),
		'BD-64' => __( 'Thakurgaon', 'learning-management-system' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'learning-management-system' ),
		'BG-02' => __( 'Burgas', 'learning-management-system' ),
		'BG-08' => __( 'Dobrich', 'learning-management-system' ),
		'BG-07' => __( 'Gabrovo', 'learning-management-system' ),
		'BG-26' => __( 'Haskovo', 'learning-management-system' ),
		'BG-09' => __( 'Kardzhali', 'learning-management-system' ),
		'BG-10' => __( 'Kyustendil', 'learning-management-system' ),
		'BG-11' => __( 'Lovech', 'learning-management-system' ),
		'BG-12' => __( 'Montana', 'learning-management-system' ),
		'BG-13' => __( 'Pazardzhik', 'learning-management-system' ),
		'BG-14' => __( 'Pernik', 'learning-management-system' ),
		'BG-15' => __( 'Pleven', 'learning-management-system' ),
		'BG-16' => __( 'Plovdiv', 'learning-management-system' ),
		'BG-17' => __( 'Razgrad', 'learning-management-system' ),
		'BG-18' => __( 'Ruse', 'learning-management-system' ),
		'BG-27' => __( 'Shumen', 'learning-management-system' ),
		'BG-19' => __( 'Silistra', 'learning-management-system' ),
		'BG-20' => __( 'Sliven', 'learning-management-system' ),
		'BG-21' => __( 'Smolyan', 'learning-management-system' ),
		'BG-23' => __( 'Sofia', 'learning-management-system' ),
		'BG-22' => __( 'Sofia-Grad', 'learning-management-system' ),
		'BG-24' => __( 'Stara Zagora', 'learning-management-system' ),
		'BG-25' => __( 'Targovishte', 'learning-management-system' ),
		'BG-03' => __( 'Varna', 'learning-management-system' ),
		'BG-04' => __( 'Veliko Tarnovo', 'learning-management-system' ),
		'BG-05' => __( 'Vidin', 'learning-management-system' ),
		'BG-06' => __( 'Vratsa', 'learning-management-system' ),
		'BG-28' => __( 'Yambol', 'learning-management-system' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'learning-management-system' ),
		'AK' => __( 'Atakora', 'learning-management-system' ),
		'AQ' => __( 'Atlantique', 'learning-management-system' ),
		'BO' => __( 'Borgou', 'learning-management-system' ),
		'CO' => __( 'Collines', 'learning-management-system' ),
		'KO' => __( 'Kouffo', 'learning-management-system' ),
		'DO' => __( 'Donga', 'learning-management-system' ),
		'LI' => __( 'Littoral', 'learning-management-system' ),
		'MO' => __( 'Mono', 'learning-management-system' ),
		'OU' => __( 'Ouémé', 'learning-management-system' ),
		'PL' => __( 'Plateau', 'learning-management-system' ),
		'ZO' => __( 'Zou', 'learning-management-system' ),
	),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca', 'learning-management-system' ),
		'H' => __( 'Beni', 'learning-management-system' ),
		'C' => __( 'Cochabamba', 'learning-management-system' ),
		'L' => __( 'La Paz', 'learning-management-system' ),
		'O' => __( 'Oruro', 'learning-management-system' ),
		'N' => __( 'Pando', 'learning-management-system' ),
		'P' => __( 'Potosí', 'learning-management-system' ),
		'S' => __( 'Santa Cruz', 'learning-management-system' ),
		'T' => __( 'Tarija', 'learning-management-system' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'learning-management-system' ),
		'AL' => __( 'Alagoas', 'learning-management-system' ),
		'AP' => __( 'Amapá', 'learning-management-system' ),
		'AM' => __( 'Amazonas', 'learning-management-system' ),
		'BA' => __( 'Bahia', 'learning-management-system' ),
		'CE' => __( 'Ceará', 'learning-management-system' ),
		'DF' => __( 'Distrito Federal', 'learning-management-system' ),
		'ES' => __( 'Espírito Santo', 'learning-management-system' ),
		'GO' => __( 'Goiás', 'learning-management-system' ),
		'MA' => __( 'Maranhão', 'learning-management-system' ),
		'MT' => __( 'Mato Grosso', 'learning-management-system' ),
		'MS' => __( 'Mato Grosso do Sul', 'learning-management-system' ),
		'MG' => __( 'Minas Gerais', 'learning-management-system' ),
		'PA' => __( 'Pará', 'learning-management-system' ),
		'PB' => __( 'Paraíba', 'learning-management-system' ),
		'PR' => __( 'Paraná', 'learning-management-system' ),
		'PE' => __( 'Pernambuco', 'learning-management-system' ),
		'PI' => __( 'Piauí', 'learning-management-system' ),
		'RJ' => __( 'Rio de Janeiro', 'learning-management-system' ),
		'RN' => __( 'Rio Grande do Norte', 'learning-management-system' ),
		'RS' => __( 'Rio Grande do Sul', 'learning-management-system' ),
		'RO' => __( 'Rondônia', 'learning-management-system' ),
		'RR' => __( 'Roraima', 'learning-management-system' ),
		'SC' => __( 'Santa Catarina', 'learning-management-system' ),
		'SP' => __( 'São Paulo', 'learning-management-system' ),
		'SE' => __( 'Sergipe', 'learning-management-system' ),
		'TO' => __( 'Tocantins', 'learning-management-system' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'learning-management-system' ),
		'BC' => __( 'British Columbia', 'learning-management-system' ),
		'MB' => __( 'Manitoba', 'learning-management-system' ),
		'NB' => __( 'New Brunswick', 'learning-management-system' ),
		'NL' => __( 'Newfoundland and Labrador', 'learning-management-system' ),
		'NT' => __( 'Northwest Territories', 'learning-management-system' ),
		'NS' => __( 'Nova Scotia', 'learning-management-system' ),
		'NU' => __( 'Nunavut', 'learning-management-system' ),
		'ON' => __( 'Ontario', 'learning-management-system' ),
		'PE' => __( 'Prince Edward Island', 'learning-management-system' ),
		'QC' => __( 'Quebec', 'learning-management-system' ),
		'SK' => __( 'Saskatchewan', 'learning-management-system' ),
		'YT' => __( 'Yukon Territory', 'learning-management-system' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'learning-management-system' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'learning-management-system' ),
		'AI' => __( 'Appenzell Innerrhoden', 'learning-management-system' ),
		'BL' => __( 'Basel-Landschaft', 'learning-management-system' ),
		'BS' => __( 'Basel-Stadt', 'learning-management-system' ),
		'BE' => __( 'Bern', 'learning-management-system' ),
		'FR' => __( 'Fribourg', 'learning-management-system' ),
		'GE' => __( 'Geneva', 'learning-management-system' ),
		'GL' => __( 'Glarus', 'learning-management-system' ),
		'GR' => __( 'Graubünden', 'learning-management-system' ),
		'JU' => __( 'Jura', 'learning-management-system' ),
		'LU' => __( 'Luzern', 'learning-management-system' ),
		'NE' => __( 'Neuchâtel', 'learning-management-system' ),
		'NW' => __( 'Nidwalden', 'learning-management-system' ),
		'OW' => __( 'Obwalden', 'learning-management-system' ),
		'SH' => __( 'Schaffhausen', 'learning-management-system' ),
		'SZ' => __( 'Schwyz', 'learning-management-system' ),
		'SO' => __( 'Solothurn', 'learning-management-system' ),
		'SG' => __( 'St. Gallen', 'learning-management-system' ),
		'TG' => __( 'Thurgau', 'learning-management-system' ),
		'TI' => __( 'Ticino', 'learning-management-system' ),
		'UR' => __( 'Uri', 'learning-management-system' ),
		'VS' => __( 'Valais', 'learning-management-system' ),
		'VD' => __( 'Vaud', 'learning-management-system' ),
		'ZG' => __( 'Zug', 'learning-management-system' ),
		'ZH' => __( 'Zürich', 'learning-management-system' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'learning-management-system' ),
		'CN2'  => __( 'Beijing / 北京', 'learning-management-system' ),
		'CN3'  => __( 'Tianjin / 天津', 'learning-management-system' ),
		'CN4'  => __( 'Hebei / 河北', 'learning-management-system' ),
		'CN5'  => __( 'Shanxi / 山西', 'learning-management-system' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'learning-management-system' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'learning-management-system' ),
		'CN8'  => __( 'Jilin / 吉林', 'learning-management-system' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'learning-management-system' ),
		'CN10' => __( 'Shanghai / 上海', 'learning-management-system' ),
		'CN11' => __( 'Jiangsu / 江苏', 'learning-management-system' ),
		'CN12' => __( 'Zhejiang / 浙江', 'learning-management-system' ),
		'CN13' => __( 'Anhui / 安徽', 'learning-management-system' ),
		'CN14' => __( 'Fujian / 福建', 'learning-management-system' ),
		'CN15' => __( 'Jiangxi / 江西', 'learning-management-system' ),
		'CN16' => __( 'Shandong / 山东', 'learning-management-system' ),
		'CN17' => __( 'Henan / 河南', 'learning-management-system' ),
		'CN18' => __( 'Hubei / 湖北', 'learning-management-system' ),
		'CN19' => __( 'Hunan / 湖南', 'learning-management-system' ),
		'CN20' => __( 'Guangdong / 广东', 'learning-management-system' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'learning-management-system' ),
		'CN22' => __( 'Hainan / 海南', 'learning-management-system' ),
		'CN23' => __( 'Chongqing / 重庆', 'learning-management-system' ),
		'CN24' => __( 'Sichuan / 四川', 'learning-management-system' ),
		'CN25' => __( 'Guizhou / 贵州', 'learning-management-system' ),
		'CN26' => __( 'Shaanxi / 陕西', 'learning-management-system' ),
		'CN27' => __( 'Gansu / 甘肃', 'learning-management-system' ),
		'CN28' => __( 'Qinghai / 青海', 'learning-management-system' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'learning-management-system' ),
		'CN30' => __( 'Macao / 澳门', 'learning-management-system' ),
		'CN31' => __( 'Tibet / 西藏', 'learning-management-system' ),
		'CN32' => __( 'Xinjiang / 新疆', 'learning-management-system' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'learning-management-system' ),
		'DZ-02' => __( 'Chlef', 'learning-management-system' ),
		'DZ-03' => __( 'Laghouat', 'learning-management-system' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'learning-management-system' ),
		'DZ-05' => __( 'Batna', 'learning-management-system' ),
		'DZ-06' => __( 'Béjaïa', 'learning-management-system' ),
		'DZ-07' => __( 'Biskra', 'learning-management-system' ),
		'DZ-08' => __( 'Béchar', 'learning-management-system' ),
		'DZ-09' => __( 'Blida', 'learning-management-system' ),
		'DZ-10' => __( 'Bouira', 'learning-management-system' ),
		'DZ-11' => __( 'Tamanghasset', 'learning-management-system' ),
		'DZ-12' => __( 'Tébessa', 'learning-management-system' ),
		'DZ-13' => __( 'Tlemcen', 'learning-management-system' ),
		'DZ-14' => __( 'Tiaret', 'learning-management-system' ),
		'DZ-15' => __( 'Tizi Ouzou', 'learning-management-system' ),
		'DZ-16' => __( 'Algiers', 'learning-management-system' ),
		'DZ-17' => __( 'Djelfa', 'learning-management-system' ),
		'DZ-18' => __( 'Jijel', 'learning-management-system' ),
		'DZ-19' => __( 'Sétif', 'learning-management-system' ),
		'DZ-20' => __( 'Saïda', 'learning-management-system' ),
		'DZ-21' => __( 'Skikda', 'learning-management-system' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'learning-management-system' ),
		'DZ-23' => __( 'Annaba', 'learning-management-system' ),
		'DZ-24' => __( 'Guelma', 'learning-management-system' ),
		'DZ-25' => __( 'Constantine', 'learning-management-system' ),
		'DZ-26' => __( 'Médéa', 'learning-management-system' ),
		'DZ-27' => __( 'Mostaganem', 'learning-management-system' ),
		'DZ-28' => __( 'M’Sila', 'learning-management-system' ),
		'DZ-29' => __( 'Mascara', 'learning-management-system' ),
		'DZ-30' => __( 'Ouargla', 'learning-management-system' ),
		'DZ-31' => __( 'Oran', 'learning-management-system' ),
		'DZ-32' => __( 'El Bayadh', 'learning-management-system' ),
		'DZ-33' => __( 'Illizi', 'learning-management-system' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'learning-management-system' ),
		'DZ-35' => __( 'Boumerdès', 'learning-management-system' ),
		'DZ-36' => __( 'El Tarf', 'learning-management-system' ),
		'DZ-37' => __( 'Tindouf', 'learning-management-system' ),
		'DZ-38' => __( 'Tissemsilt', 'learning-management-system' ),
		'DZ-39' => __( 'El Oued', 'learning-management-system' ),
		'DZ-40' => __( 'Khenchela', 'learning-management-system' ),
		'DZ-41' => __( 'Souk Ahras', 'learning-management-system' ),
		'DZ-42' => __( 'Tipasa', 'learning-management-system' ),
		'DZ-43' => __( 'Mila', 'learning-management-system' ),
		'DZ-44' => __( 'Aïn Defla', 'learning-management-system' ),
		'DZ-45' => __( 'Naama', 'learning-management-system' ),
		'DZ-46' => __( 'Aïn Témouchent', 'learning-management-system' ),
		'DZ-47' => __( 'Ghardaïa', 'learning-management-system' ),
		'DZ-48' => __( 'Relizane', 'learning-management-system' ),
	),
	'EE' => array(),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'learning-management-system' ),
		'EGASN' => __( 'Aswan', 'learning-management-system' ),
		'EGAST' => __( 'Asyut', 'learning-management-system' ),
		'EGBA'  => __( 'Red Sea', 'learning-management-system' ),
		'EGBH'  => __( 'Beheira', 'learning-management-system' ),
		'EGBNS' => __( 'Beni Suef', 'learning-management-system' ),
		'EGC'   => __( 'Cairo', 'learning-management-system' ),
		'EGDK'  => __( 'Dakahlia', 'learning-management-system' ),
		'EGDT'  => __( 'Damietta', 'learning-management-system' ),
		'EGFYM' => __( 'Faiyum', 'learning-management-system' ),
		'EGGH'  => __( 'Gharbia', 'learning-management-system' ),
		'EGGZ'  => __( 'Giza', 'learning-management-system' ),
		'EGIS'  => __( 'Ismailia', 'learning-management-system' ),
		'EGJS'  => __( 'South Sinai', 'learning-management-system' ),
		'EGKB'  => __( 'Qalyubia', 'learning-management-system' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'learning-management-system' ),
		'EGKN'  => __( 'Qena', 'learning-management-system' ),
		'EGLX'  => __( 'Luxor', 'learning-management-system' ),
		'EGMN'  => __( 'Minya', 'learning-management-system' ),
		'EGMNF' => __( 'Monufia', 'learning-management-system' ),
		'EGMT'  => __( 'Matrouh', 'learning-management-system' ),
		'EGPTS' => __( 'Port Said', 'learning-management-system' ),
		'EGSHG' => __( 'Sohag', 'learning-management-system' ),
		'EGSHR' => __( 'Al Sharqia', 'learning-management-system' ),
		'EGSIN' => __( 'North Sinai', 'learning-management-system' ),
		'EGSUZ' => __( 'Suez', 'learning-management-system' ),
		'EGWAD' => __( 'New Valley', 'learning-management-system' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'learning-management-system' ),
		'VI' => __( 'Araba/Álava', 'learning-management-system' ),
		'AB' => __( 'Albacete', 'learning-management-system' ),
		'A'  => __( 'Alicante', 'learning-management-system' ),
		'AL' => __( 'Almería', 'learning-management-system' ),
		'O'  => __( 'Asturias', 'learning-management-system' ),
		'AV' => __( 'Ávila', 'learning-management-system' ),
		'BA' => __( 'Badajoz', 'learning-management-system' ),
		'PM' => __( 'Baleares', 'learning-management-system' ),
		'B'  => __( 'Barcelona', 'learning-management-system' ),
		'BU' => __( 'Burgos', 'learning-management-system' ),
		'CC' => __( 'Cáceres', 'learning-management-system' ),
		'CA' => __( 'Cádiz', 'learning-management-system' ),
		'S'  => __( 'Cantabria', 'learning-management-system' ),
		'CS' => __( 'Castellón', 'learning-management-system' ),
		'CE' => __( 'Ceuta', 'learning-management-system' ),
		'CR' => __( 'Ciudad Real', 'learning-management-system' ),
		'CO' => __( 'Córdoba', 'learning-management-system' ),
		'CU' => __( 'Cuenca', 'learning-management-system' ),
		'GI' => __( 'Girona', 'learning-management-system' ),
		'GR' => __( 'Granada', 'learning-management-system' ),
		'GU' => __( 'Guadalajara', 'learning-management-system' ),
		'SS' => __( 'Gipuzkoa', 'learning-management-system' ),
		'H'  => __( 'Huelva', 'learning-management-system' ),
		'HU' => __( 'Huesca', 'learning-management-system' ),
		'J'  => __( 'Jaén', 'learning-management-system' ),
		'LO' => __( 'La Rioja', 'learning-management-system' ),
		'GC' => __( 'Las Palmas', 'learning-management-system' ),
		'LE' => __( 'León', 'learning-management-system' ),
		'L'  => __( 'Lleida', 'learning-management-system' ),
		'LU' => __( 'Lugo', 'learning-management-system' ),
		'M'  => __( 'Madrid', 'learning-management-system' ),
		'MA' => __( 'Málaga', 'learning-management-system' ),
		'ML' => __( 'Melilla', 'learning-management-system' ),
		'MU' => __( 'Murcia', 'learning-management-system' ),
		'NA' => __( 'Navarra', 'learning-management-system' ),
		'OR' => __( 'Ourense', 'learning-management-system' ),
		'P'  => __( 'Palencia', 'learning-management-system' ),
		'PO' => __( 'Pontevedra', 'learning-management-system' ),
		'SA' => __( 'Salamanca', 'learning-management-system' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'learning-management-system' ),
		'SG' => __( 'Segovia', 'learning-management-system' ),
		'SE' => __( 'Sevilla', 'learning-management-system' ),
		'SO' => __( 'Soria', 'learning-management-system' ),
		'T'  => __( 'Tarragona', 'learning-management-system' ),
		'TE' => __( 'Teruel', 'learning-management-system' ),
		'TO' => __( 'Toledo', 'learning-management-system' ),
		'V'  => __( 'Valencia', 'learning-management-system' ),
		'VA' => __( 'Valladolid', 'learning-management-system' ),
		'BI' => __( 'Biscay', 'learning-management-system' ),
		'ZA' => __( 'Zamora', 'learning-management-system' ),
		'Z'  => __( 'Zaragoza', 'learning-management-system' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'learning-management-system' ),
		'AH' => __( 'Ashanti', 'learning-management-system' ),
		'BA' => __( 'Brong-Ahafo', 'learning-management-system' ),
		'BO' => __( 'Bono', 'learning-management-system' ),
		'BE' => __( 'Bono East', 'learning-management-system' ),
		'CP' => __( 'Central', 'learning-management-system' ),
		'EP' => __( 'Eastern', 'learning-management-system' ),
		'AA' => __( 'Greater Accra', 'learning-management-system' ),
		'NE' => __( 'North East', 'learning-management-system' ),
		'NP' => __( 'Northern', 'learning-management-system' ),
		'OT' => __( 'Oti', 'learning-management-system' ),
		'SV' => __( 'Savannah', 'learning-management-system' ),
		'UE' => __( 'Upper East', 'learning-management-system' ),
		'UW' => __( 'Upper West', 'learning-management-system' ),
		'TV' => __( 'Volta', 'learning-management-system' ),
		'WP' => __( 'Western', 'learning-management-system' ),
		'WN' => __( 'Western North', 'learning-management-system' ),
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'learning-management-system' ),
		'A' => __( 'East Macedonia and Thrace', 'learning-management-system' ),
		'B' => __( 'Central Macedonia', 'learning-management-system' ),
		'C' => __( 'West Macedonia', 'learning-management-system' ),
		'D' => __( 'Epirus', 'learning-management-system' ),
		'E' => __( 'Thessaly', 'learning-management-system' ),
		'F' => __( 'Ionian Islands', 'learning-management-system' ),
		'G' => __( 'West Greece', 'learning-management-system' ),
		'H' => __( 'Central Greece', 'learning-management-system' ),
		'J' => __( 'Peloponnese', 'learning-management-system' ),
		'K' => __( 'North Aegean', 'learning-management-system' ),
		'L' => __( 'South Aegean', 'learning-management-system' ),
		'M' => __( 'Crete', 'learning-management-system' ),
	),
	'GF' => array(),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'learning-management-system' ),
		'KOWLOON'         => __( 'Kowloon', 'learning-management-system' ),
		'NEW TERRITORIES' => __( 'New Territories', 'learning-management-system' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'learning-management-system' ),
		'BE' => __( 'Békés', 'learning-management-system' ),
		'BA' => __( 'Baranya', 'learning-management-system' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'learning-management-system' ),
		'BU' => __( 'Budapest', 'learning-management-system' ),
		'CS' => __( 'Csongrád-Csanád', 'learning-management-system' ),
		'FE' => __( 'Fejér', 'learning-management-system' ),
		'GS' => __( 'Győr-Moson-Sopron', 'learning-management-system' ),
		'HB' => __( 'Hajdú-Bihar', 'learning-management-system' ),
		'HE' => __( 'Heves', 'learning-management-system' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'learning-management-system' ),
		'KE' => __( 'Komárom-Esztergom', 'learning-management-system' ),
		'NO' => __( 'Nógrád', 'learning-management-system' ),
		'PE' => __( 'Pest', 'learning-management-system' ),
		'SO' => __( 'Somogy', 'learning-management-system' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'learning-management-system' ),
		'TO' => __( 'Tolna', 'learning-management-system' ),
		'VA' => __( 'Vas', 'learning-management-system' ),
		'VE' => __( 'Veszprém', 'learning-management-system' ),
		'ZA' => __( 'Zala', 'learning-management-system' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'learning-management-system' ),
		'SU' => __( 'Sumatera Utara', 'learning-management-system' ),
		'SB' => __( 'Sumatera Barat', 'learning-management-system' ),
		'RI' => __( 'Riau', 'learning-management-system' ),
		'KR' => __( 'Kepulauan Riau', 'learning-management-system' ),
		'JA' => __( 'Jambi', 'learning-management-system' ),
		'SS' => __( 'Sumatera Selatan', 'learning-management-system' ),
		'BB' => __( 'Bangka Belitung', 'learning-management-system' ),
		'BE' => __( 'Bengkulu', 'learning-management-system' ),
		'LA' => __( 'Lampung', 'learning-management-system' ),
		'JK' => __( 'DKI Jakarta', 'learning-management-system' ),
		'JB' => __( 'Jawa Barat', 'learning-management-system' ),
		'BT' => __( 'Banten', 'learning-management-system' ),
		'JT' => __( 'Jawa Tengah', 'learning-management-system' ),
		'JI' => __( 'Jawa Timur', 'learning-management-system' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'learning-management-system' ),
		'BA' => __( 'Bali', 'learning-management-system' ),
		'NB' => __( 'Nusa Tenggara Barat', 'learning-management-system' ),
		'NT' => __( 'Nusa Tenggara Timur', 'learning-management-system' ),
		'KB' => __( 'Kalimantan Barat', 'learning-management-system' ),
		'KT' => __( 'Kalimantan Tengah', 'learning-management-system' ),
		'KI' => __( 'Kalimantan Timur', 'learning-management-system' ),
		'KS' => __( 'Kalimantan Selatan', 'learning-management-system' ),
		'KU' => __( 'Kalimantan Utara', 'learning-management-system' ),
		'SA' => __( 'Sulawesi Utara', 'learning-management-system' ),
		'ST' => __( 'Sulawesi Tengah', 'learning-management-system' ),
		'SG' => __( 'Sulawesi Tenggara', 'learning-management-system' ),
		'SR' => __( 'Sulawesi Barat', 'learning-management-system' ),
		'SN' => __( 'Sulawesi Selatan', 'learning-management-system' ),
		'GO' => __( 'Gorontalo', 'learning-management-system' ),
		'MA' => __( 'Maluku', 'learning-management-system' ),
		'MU' => __( 'Maluku Utara', 'learning-management-system' ),
		'PA' => __( 'Papua', 'learning-management-system' ),
		'PB' => __( 'Papua Barat', 'learning-management-system' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'learning-management-system' ),
		'CN' => __( 'Cavan', 'learning-management-system' ),
		'CE' => __( 'Clare', 'learning-management-system' ),
		'CO' => __( 'Cork', 'learning-management-system' ),
		'DL' => __( 'Donegal', 'learning-management-system' ),
		'D'  => __( 'Dublin', 'learning-management-system' ),
		'G'  => __( 'Galway', 'learning-management-system' ),
		'KY' => __( 'Kerry', 'learning-management-system' ),
		'KE' => __( 'Kildare', 'learning-management-system' ),
		'KK' => __( 'Kilkenny', 'learning-management-system' ),
		'LS' => __( 'Laois', 'learning-management-system' ),
		'LM' => __( 'Leitrim', 'learning-management-system' ),
		'LK' => __( 'Limerick', 'learning-management-system' ),
		'LD' => __( 'Longford', 'learning-management-system' ),
		'LH' => __( 'Louth', 'learning-management-system' ),
		'MO' => __( 'Mayo', 'learning-management-system' ),
		'MH' => __( 'Meath', 'learning-management-system' ),
		'MN' => __( 'Monaghan', 'learning-management-system' ),
		'OY' => __( 'Offaly', 'learning-management-system' ),
		'RN' => __( 'Roscommon', 'learning-management-system' ),
		'SO' => __( 'Sligo', 'learning-management-system' ),
		'TA' => __( 'Tipperary', 'learning-management-system' ),
		'WD' => __( 'Waterford', 'learning-management-system' ),
		'WH' => __( 'Westmeath', 'learning-management-system' ),
		'WX' => __( 'Wexford', 'learning-management-system' ),
		'WW' => __( 'Wicklow', 'learning-management-system' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'learning-management-system' ),
		'AR' => __( 'Arunachal Pradesh', 'learning-management-system' ),
		'AS' => __( 'Assam', 'learning-management-system' ),
		'BR' => __( 'Bihar', 'learning-management-system' ),
		'CT' => __( 'Chhattisgarh', 'learning-management-system' ),
		'GA' => __( 'Goa', 'learning-management-system' ),
		'GJ' => __( 'Gujarat', 'learning-management-system' ),
		'HR' => __( 'Haryana', 'learning-management-system' ),
		'HP' => __( 'Himachal Pradesh', 'learning-management-system' ),
		'JK' => __( 'Jammu and Kashmir', 'learning-management-system' ),
		'JH' => __( 'Jharkhand', 'learning-management-system' ),
		'KA' => __( 'Karnataka', 'learning-management-system' ),
		'KL' => __( 'Kerala', 'learning-management-system' ),
		'MP' => __( 'Madhya Pradesh', 'learning-management-system' ),
		'MH' => __( 'Maharashtra', 'learning-management-system' ),
		'MN' => __( 'Manipur', 'learning-management-system' ),
		'ML' => __( 'Meghalaya', 'learning-management-system' ),
		'MZ' => __( 'Mizoram', 'learning-management-system' ),
		'NL' => __( 'Nagaland', 'learning-management-system' ),
		'OR' => __( 'Orissa', 'learning-management-system' ),
		'PB' => __( 'Punjab', 'learning-management-system' ),
		'RJ' => __( 'Rajasthan', 'learning-management-system' ),
		'SK' => __( 'Sikkim', 'learning-management-system' ),
		'TN' => __( 'Tamil Nadu', 'learning-management-system' ),
		'TS' => __( 'Telangana', 'learning-management-system' ),
		'TR' => __( 'Tripura', 'learning-management-system' ),
		'UK' => __( 'Uttarakhand', 'learning-management-system' ),
		'UP' => __( 'Uttar Pradesh', 'learning-management-system' ),
		'WB' => __( 'West Bengal', 'learning-management-system' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'learning-management-system' ),
		'CH' => __( 'Chandigarh', 'learning-management-system' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'learning-management-system' ),
		'DD' => __( 'Daman and Diu', 'learning-management-system' ),
		'DL' => __( 'Delhi', 'learning-management-system' ),
		'LD' => __( 'Lakshadeep', 'learning-management-system' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'learning-management-system' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan  (خوزستان)', 'learning-management-system' ),
		'THR' => __( 'Tehran  (تهران)', 'learning-management-system' ),
		'ILM' => __( 'Ilaam (ایلام)', 'learning-management-system' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'learning-management-system' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'learning-management-system' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'learning-management-system' ),
		'YZD' => __( 'Yazd (یزد)', 'learning-management-system' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'learning-management-system' ),
		'KRN' => __( 'Kerman (کرمان)', 'learning-management-system' ),
		'HDN' => __( 'Hamadan (همدان)', 'learning-management-system' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'learning-management-system' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'learning-management-system' ),
		'LRS' => __( 'Luristan (لرستان)', 'learning-management-system' ),
		'ABZ' => __( 'Alborz (البرز)', 'learning-management-system' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'learning-management-system' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'learning-management-system' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'learning-management-system' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'learning-management-system' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'learning-management-system' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'learning-management-system' ),
		'SMN' => __( 'Semnan (سمنان)', 'learning-management-system' ),
		'FRS' => __( 'Fars (فارس)', 'learning-management-system' ),
		'QHM' => __( 'Qom (قم)', 'learning-management-system' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'learning-management-system' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'learning-management-system' ),
		'GLS' => __( 'Golestan (گلستان)', 'learning-management-system' ),
		'GIL' => __( 'Gilan (گیلان)', 'learning-management-system' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'learning-management-system' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'learning-management-system' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'learning-management-system' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'learning-management-system' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'learning-management-system' ),
		'AL' => __( 'Alessandria', 'learning-management-system' ),
		'AN' => __( 'Ancona', 'learning-management-system' ),
		'AO' => __( 'Aosta', 'learning-management-system' ),
		'AR' => __( 'Arezzo', 'learning-management-system' ),
		'AP' => __( 'Ascoli Piceno', 'learning-management-system' ),
		'AT' => __( 'Asti', 'learning-management-system' ),
		'AV' => __( 'Avellino', 'learning-management-system' ),
		'BA' => __( 'Bari', 'learning-management-system' ),
		'BT' => __( 'Barletta-Andria-Trani', 'learning-management-system' ),
		'BL' => __( 'Belluno', 'learning-management-system' ),
		'BN' => __( 'Benevento', 'learning-management-system' ),
		'BG' => __( 'Bergamo', 'learning-management-system' ),
		'BI' => __( 'Biella', 'learning-management-system' ),
		'BO' => __( 'Bologna', 'learning-management-system' ),
		'BZ' => __( 'Bolzano', 'learning-management-system' ),
		'BS' => __( 'Brescia', 'learning-management-system' ),
		'BR' => __( 'Brindisi', 'learning-management-system' ),
		'CA' => __( 'Cagliari', 'learning-management-system' ),
		'CL' => __( 'Caltanissetta', 'learning-management-system' ),
		'CB' => __( 'Campobasso', 'learning-management-system' ),
		'CE' => __( 'Caserta', 'learning-management-system' ),
		'CT' => __( 'Catania', 'learning-management-system' ),
		'CZ' => __( 'Catanzaro', 'learning-management-system' ),
		'CH' => __( 'Chieti', 'learning-management-system' ),
		'CO' => __( 'Como', 'learning-management-system' ),
		'CS' => __( 'Cosenza', 'learning-management-system' ),
		'CR' => __( 'Cremona', 'learning-management-system' ),
		'KR' => __( 'Crotone', 'learning-management-system' ),
		'CN' => __( 'Cuneo', 'learning-management-system' ),
		'EN' => __( 'Enna', 'learning-management-system' ),
		'FM' => __( 'Fermo', 'learning-management-system' ),
		'FE' => __( 'Ferrara', 'learning-management-system' ),
		'FI' => __( 'Firenze', 'learning-management-system' ),
		'FG' => __( 'Foggia', 'learning-management-system' ),
		'FC' => __( 'Forlì-Cesena', 'learning-management-system' ),
		'FR' => __( 'Frosinone', 'learning-management-system' ),
		'GE' => __( 'Genova', 'learning-management-system' ),
		'GO' => __( 'Gorizia', 'learning-management-system' ),
		'GR' => __( 'Grosseto', 'learning-management-system' ),
		'IM' => __( 'Imperia', 'learning-management-system' ),
		'IS' => __( 'Isernia', 'learning-management-system' ),
		'SP' => __( 'La Spezia', 'learning-management-system' ),
		'AQ' => __( "L'Aquila", 'learning-management-system' ),
		'LT' => __( 'Latina', 'learning-management-system' ),
		'LE' => __( 'Lecce', 'learning-management-system' ),
		'LC' => __( 'Lecco', 'learning-management-system' ),
		'LI' => __( 'Livorno', 'learning-management-system' ),
		'LO' => __( 'Lodi', 'learning-management-system' ),
		'LU' => __( 'Lucca', 'learning-management-system' ),
		'MC' => __( 'Macerata', 'learning-management-system' ),
		'MN' => __( 'Mantova', 'learning-management-system' ),
		'MS' => __( 'Massa-Carrara', 'learning-management-system' ),
		'MT' => __( 'Matera', 'learning-management-system' ),
		'ME' => __( 'Messina', 'learning-management-system' ),
		'MI' => __( 'Milano', 'learning-management-system' ),
		'MO' => __( 'Modena', 'learning-management-system' ),
		'MB' => __( 'Monza e della Brianza', 'learning-management-system' ),
		'NA' => __( 'Napoli', 'learning-management-system' ),
		'NO' => __( 'Novara', 'learning-management-system' ),
		'NU' => __( 'Nuoro', 'learning-management-system' ),
		'OR' => __( 'Oristano', 'learning-management-system' ),
		'PD' => __( 'Padova', 'learning-management-system' ),
		'PA' => __( 'Palermo', 'learning-management-system' ),
		'PR' => __( 'Parma', 'learning-management-system' ),
		'PV' => __( 'Pavia', 'learning-management-system' ),
		'PG' => __( 'Perugia', 'learning-management-system' ),
		'PU' => __( 'Pesaro e Urbino', 'learning-management-system' ),
		'PE' => __( 'Pescara', 'learning-management-system' ),
		'PC' => __( 'Piacenza', 'learning-management-system' ),
		'PI' => __( 'Pisa', 'learning-management-system' ),
		'PT' => __( 'Pistoia', 'learning-management-system' ),
		'PN' => __( 'Pordenone', 'learning-management-system' ),
		'PZ' => __( 'Potenza', 'learning-management-system' ),
		'PO' => __( 'Prato', 'learning-management-system' ),
		'RG' => __( 'Ragusa', 'learning-management-system' ),
		'RA' => __( 'Ravenna', 'learning-management-system' ),
		'RC' => __( 'Reggio Calabria', 'learning-management-system' ),
		'RE' => __( 'Reggio Emilia', 'learning-management-system' ),
		'RI' => __( 'Rieti', 'learning-management-system' ),
		'RN' => __( 'Rimini', 'learning-management-system' ),
		'RM' => __( 'Roma', 'learning-management-system' ),
		'RO' => __( 'Rovigo', 'learning-management-system' ),
		'SA' => __( 'Salerno', 'learning-management-system' ),
		'SS' => __( 'Sassari', 'learning-management-system' ),
		'SV' => __( 'Savona', 'learning-management-system' ),
		'SI' => __( 'Siena', 'learning-management-system' ),
		'SR' => __( 'Siracusa', 'learning-management-system' ),
		'SO' => __( 'Sondrio', 'learning-management-system' ),
		'SU' => __( 'Sud Sardegna', 'learning-management-system' ),
		'TA' => __( 'Taranto', 'learning-management-system' ),
		'TE' => __( 'Teramo', 'learning-management-system' ),
		'TR' => __( 'Terni', 'learning-management-system' ),
		'TO' => __( 'Torino', 'learning-management-system' ),
		'TP' => __( 'Trapani', 'learning-management-system' ),
		'TN' => __( 'Trento', 'learning-management-system' ),
		'TV' => __( 'Treviso', 'learning-management-system' ),
		'TS' => __( 'Trieste', 'learning-management-system' ),
		'UD' => __( 'Udine', 'learning-management-system' ),
		'VA' => __( 'Varese', 'learning-management-system' ),
		'VE' => __( 'Venezia', 'learning-management-system' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'learning-management-system' ),
		'VC' => __( 'Vercelli', 'learning-management-system' ),
		'VR' => __( 'Verona', 'learning-management-system' ),
		'VV' => __( 'Vibo Valentia', 'learning-management-system' ),
		'VI' => __( 'Vicenza', 'learning-management-system' ),
		'VT' => __( 'Viterbo', 'learning-management-system' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
		'JM-01' => __( 'Kingston', 'learning-management-system' ),
		'JM-02' => __( 'Saint Andrew', 'learning-management-system' ),
		'JM-03' => __( 'Saint Thomas', 'learning-management-system' ),
		'JM-04' => __( 'Portland', 'learning-management-system' ),
		'JM-05' => __( 'Saint Mary', 'learning-management-system' ),
		'JM-06' => __( 'Saint Ann', 'learning-management-system' ),
		'JM-07' => __( 'Trelawny', 'learning-management-system' ),
		'JM-08' => __( 'Saint James', 'learning-management-system' ),
		'JM-09' => __( 'Hanover', 'learning-management-system' ),
		'JM-10' => __( 'Westmoreland', 'learning-management-system' ),
		'JM-11' => __( 'Saint Elizabeth', 'learning-management-system' ),
		'JM-12' => __( 'Manchester', 'learning-management-system' ),
		'JM-13' => __( 'Clarendon', 'learning-management-system' ),
		'JM-14' => __( 'Saint Catherine', 'learning-management-system' ),
	),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'learning-management-system' ),
		'JP02' => __( 'Aomori', 'learning-management-system' ),
		'JP03' => __( 'Iwate', 'learning-management-system' ),
		'JP04' => __( 'Miyagi', 'learning-management-system' ),
		'JP05' => __( 'Akita', 'learning-management-system' ),
		'JP06' => __( 'Yamagata', 'learning-management-system' ),
		'JP07' => __( 'Fukushima', 'learning-management-system' ),
		'JP08' => __( 'Ibaraki', 'learning-management-system' ),
		'JP09' => __( 'Tochigi', 'learning-management-system' ),
		'JP10' => __( 'Gunma', 'learning-management-system' ),
		'JP11' => __( 'Saitama', 'learning-management-system' ),
		'JP12' => __( 'Chiba', 'learning-management-system' ),
		'JP13' => __( 'Tokyo', 'learning-management-system' ),
		'JP14' => __( 'Kanagawa', 'learning-management-system' ),
		'JP15' => __( 'Niigata', 'learning-management-system' ),
		'JP16' => __( 'Toyama', 'learning-management-system' ),
		'JP17' => __( 'Ishikawa', 'learning-management-system' ),
		'JP18' => __( 'Fukui', 'learning-management-system' ),
		'JP19' => __( 'Yamanashi', 'learning-management-system' ),
		'JP20' => __( 'Nagano', 'learning-management-system' ),
		'JP21' => __( 'Gifu', 'learning-management-system' ),
		'JP22' => __( 'Shizuoka', 'learning-management-system' ),
		'JP23' => __( 'Aichi', 'learning-management-system' ),
		'JP24' => __( 'Mie', 'learning-management-system' ),
		'JP25' => __( 'Shiga', 'learning-management-system' ),
		'JP26' => __( 'Kyoto', 'learning-management-system' ),
		'JP27' => __( 'Osaka', 'learning-management-system' ),
		'JP28' => __( 'Hyogo', 'learning-management-system' ),
		'JP29' => __( 'Nara', 'learning-management-system' ),
		'JP30' => __( 'Wakayama', 'learning-management-system' ),
		'JP31' => __( 'Tottori', 'learning-management-system' ),
		'JP32' => __( 'Shimane', 'learning-management-system' ),
		'JP33' => __( 'Okayama', 'learning-management-system' ),
		'JP34' => __( 'Hiroshima', 'learning-management-system' ),
		'JP35' => __( 'Yamaguchi', 'learning-management-system' ),
		'JP36' => __( 'Tokushima', 'learning-management-system' ),
		'JP37' => __( 'Kagawa', 'learning-management-system' ),
		'JP38' => __( 'Ehime', 'learning-management-system' ),
		'JP39' => __( 'Kochi', 'learning-management-system' ),
		'JP40' => __( 'Fukuoka', 'learning-management-system' ),
		'JP41' => __( 'Saga', 'learning-management-system' ),
		'JP42' => __( 'Nagasaki', 'learning-management-system' ),
		'JP43' => __( 'Kumamoto', 'learning-management-system' ),
		'JP44' => __( 'Oita', 'learning-management-system' ),
		'JP45' => __( 'Miyazaki', 'learning-management-system' ),
		'JP46' => __( 'Kagoshima', 'learning-management-system' ),
		'JP47' => __( 'Okinawa', 'learning-management-system' ),
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'learning-management-system' ),
		'KE02' => __( 'Bomet', 'learning-management-system' ),
		'KE03' => __( 'Bungoma', 'learning-management-system' ),
		'KE04' => __( 'Busia', 'learning-management-system' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'learning-management-system' ),
		'KE06' => __( 'Embu', 'learning-management-system' ),
		'KE07' => __( 'Garissa', 'learning-management-system' ),
		'KE08' => __( 'Homa Bay', 'learning-management-system' ),
		'KE09' => __( 'Isiolo', 'learning-management-system' ),
		'KE10' => __( 'Kajiado', 'learning-management-system' ),
		'KE11' => __( 'Kakamega', 'learning-management-system' ),
		'KE12' => __( 'Kericho', 'learning-management-system' ),
		'KE13' => __( 'Kiambu', 'learning-management-system' ),
		'KE14' => __( 'Kilifi', 'learning-management-system' ),
		'KE15' => __( 'Kirinyaga', 'learning-management-system' ),
		'KE16' => __( 'Kisii', 'learning-management-system' ),
		'KE17' => __( 'Kisumu', 'learning-management-system' ),
		'KE18' => __( 'Kitui', 'learning-management-system' ),
		'KE19' => __( 'Kwale', 'learning-management-system' ),
		'KE20' => __( 'Laikipia', 'learning-management-system' ),
		'KE21' => __( 'Lamu', 'learning-management-system' ),
		'KE22' => __( 'Machakos', 'learning-management-system' ),
		'KE23' => __( 'Makueni', 'learning-management-system' ),
		'KE24' => __( 'Mandera', 'learning-management-system' ),
		'KE25' => __( 'Marsabit', 'learning-management-system' ),
		'KE26' => __( 'Meru', 'learning-management-system' ),
		'KE27' => __( 'Migori', 'learning-management-system' ),
		'KE28' => __( 'Mombasa', 'learning-management-system' ),
		'KE29' => __( 'Murang’a', 'learning-management-system' ),
		'KE30' => __( 'Nairobi County', 'learning-management-system' ),
		'KE31' => __( 'Nakuru', 'learning-management-system' ),
		'KE32' => __( 'Nandi', 'learning-management-system' ),
		'KE33' => __( 'Narok', 'learning-management-system' ),
		'KE34' => __( 'Nyamira', 'learning-management-system' ),
		'KE35' => __( 'Nyandarua', 'learning-management-system' ),
		'KE36' => __( 'Nyeri', 'learning-management-system' ),
		'KE37' => __( 'Samburu', 'learning-management-system' ),
		'KE38' => __( 'Siaya', 'learning-management-system' ),
		'KE39' => __( 'Taita-Taveta', 'learning-management-system' ),
		'KE40' => __( 'Tana River', 'learning-management-system' ),
		'KE41' => __( 'Tharaka-Nithi', 'learning-management-system' ),
		'KE42' => __( 'Trans Nzoia', 'learning-management-system' ),
		'KE43' => __( 'Turkana', 'learning-management-system' ),
		'KE44' => __( 'Uasin Gishu', 'learning-management-system' ),
		'KE45' => __( 'Vihiga', 'learning-management-system' ),
		'KE46' => __( 'Wajir', 'learning-management-system' ),
		'KE47' => __( 'West Pokot', 'learning-management-system' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'learning-management-system' ),
		'BK' => __( 'Bokeo', 'learning-management-system' ),
		'BL' => __( 'Bolikhamsai', 'learning-management-system' ),
		'CH' => __( 'Champasak', 'learning-management-system' ),
		'HO' => __( 'Houaphanh', 'learning-management-system' ),
		'KH' => __( 'Khammouane', 'learning-management-system' ),
		'LM' => __( 'Luang Namtha', 'learning-management-system' ),
		'LP' => __( 'Luang Prabang', 'learning-management-system' ),
		'OU' => __( 'Oudomxay', 'learning-management-system' ),
		'PH' => __( 'Phongsaly', 'learning-management-system' ),
		'SL' => __( 'Salavan', 'learning-management-system' ),
		'SV' => __( 'Savannakhet', 'learning-management-system' ),
		'VI' => __( 'Vientiane Province', 'learning-management-system' ),
		'VT' => __( 'Vientiane', 'learning-management-system' ),
		'XA' => __( 'Sainyabuli', 'learning-management-system' ),
		'XE' => __( 'Sekong', 'learning-management-system' ),
		'XI' => __( 'Xiangkhouang', 'learning-management-system' ),
		'XS' => __( 'Xaisomboun', 'learning-management-system' ),
	),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'learning-management-system' ),
		'BN' => __( 'Bong', 'learning-management-system' ),
		'GA' => __( 'Gbarpolu', 'learning-management-system' ),
		'GB' => __( 'Grand Bassa', 'learning-management-system' ),
		'GC' => __( 'Grand Cape Mount', 'learning-management-system' ),
		'GG' => __( 'Grand Gedeh', 'learning-management-system' ),
		'GK' => __( 'Grand Kru', 'learning-management-system' ),
		'LO' => __( 'Lofa', 'learning-management-system' ),
		'MA' => __( 'Margibi', 'learning-management-system' ),
		'MY' => __( 'Maryland', 'learning-management-system' ),
		'MO' => __( 'Montserrado', 'learning-management-system' ),
		'NM' => __( 'Nimba', 'learning-management-system' ),
		'RV' => __( 'Rivercess', 'learning-management-system' ),
		'RG' => __( 'River Gee', 'learning-management-system' ),
		'SN' => __( 'Sinoe', 'learning-management-system' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'learning-management-system' ),
		'BL' => __( 'Bălți', 'learning-management-system' ),
		'AN' => __( 'Anenii Noi', 'learning-management-system' ),
		'BS' => __( 'Basarabeasca', 'learning-management-system' ),
		'BR' => __( 'Briceni', 'learning-management-system' ),
		'CH' => __( 'Cahul', 'learning-management-system' ),
		'CT' => __( 'Cantemir', 'learning-management-system' ),
		'CL' => __( 'Călărași', 'learning-management-system' ),
		'CS' => __( 'Căușeni', 'learning-management-system' ),
		'CM' => __( 'Cimișlia', 'learning-management-system' ),
		'CR' => __( 'Criuleni', 'learning-management-system' ),
		'DN' => __( 'Dondușeni', 'learning-management-system' ),
		'DR' => __( 'Drochia', 'learning-management-system' ),
		'DB' => __( 'Dubăsari', 'learning-management-system' ),
		'ED' => __( 'Edineț', 'learning-management-system' ),
		'FL' => __( 'Fălești', 'learning-management-system' ),
		'FR' => __( 'Florești', 'learning-management-system' ),
		'GE' => __( 'UTA Găgăuzia', 'learning-management-system' ),
		'GL' => __( 'Glodeni', 'learning-management-system' ),
		'HN' => __( 'Hîncești', 'learning-management-system' ),
		'IL' => __( 'Ialoveni', 'learning-management-system' ),
		'LV' => __( 'Leova', 'learning-management-system' ),
		'NS' => __( 'Nisporeni', 'learning-management-system' ),
		'OC' => __( 'Ocnița', 'learning-management-system' ),
		'OR' => __( 'Orhei', 'learning-management-system' ),
		'RZ' => __( 'Rezina', 'learning-management-system' ),
		'RS' => __( 'Rîșcani', 'learning-management-system' ),
		'SG' => __( 'Sîngerei', 'learning-management-system' ),
		'SR' => __( 'Soroca', 'learning-management-system' ),
		'ST' => __( 'Strășeni', 'learning-management-system' ),
		'SD' => __( 'Șoldănești', 'learning-management-system' ),
		'SV' => __( 'Ștefan Vodă', 'learning-management-system' ),
		'TR' => __( 'Taraclia', 'learning-management-system' ),
		'TL' => __( 'Telenești', 'learning-management-system' ),
		'UN' => __( 'Ungheni', 'learning-management-system' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'learning-management-system' ),
		'JA' => __( 'Jalisco', 'learning-management-system' ),
		'NL' => __( 'Nuevo León', 'learning-management-system' ),
		'AG' => __( 'Aguascalientes', 'learning-management-system' ),
		'BC' => __( 'Baja California', 'learning-management-system' ),
		'BS' => __( 'Baja California Sur', 'learning-management-system' ),
		'CM' => __( 'Campeche', 'learning-management-system' ),
		'CS' => __( 'Chiapas', 'learning-management-system' ),
		'CH' => __( 'Chihuahua', 'learning-management-system' ),
		'CO' => __( 'Coahuila', 'learning-management-system' ),
		'CL' => __( 'Colima', 'learning-management-system' ),
		'DG' => __( 'Durango', 'learning-management-system' ),
		'GT' => __( 'Guanajuato', 'learning-management-system' ),
		'GR' => __( 'Guerrero', 'learning-management-system' ),
		'HG' => __( 'Hidalgo', 'learning-management-system' ),
		'MX' => __( 'Estado de México', 'learning-management-system' ),
		'MI' => __( 'Michoacán', 'learning-management-system' ),
		'MO' => __( 'Morelos', 'learning-management-system' ),
		'NA' => __( 'Nayarit', 'learning-management-system' ),
		'OA' => __( 'Oaxaca', 'learning-management-system' ),
		'PU' => __( 'Puebla', 'learning-management-system' ),
		'QT' => __( 'Querétaro', 'learning-management-system' ),
		'QR' => __( 'Quintana Roo', 'learning-management-system' ),
		'SL' => __( 'San Luis Potosí', 'learning-management-system' ),
		'SI' => __( 'Sinaloa', 'learning-management-system' ),
		'SO' => __( 'Sonora', 'learning-management-system' ),
		'TB' => __( 'Tabasco', 'learning-management-system' ),
		'TM' => __( 'Tamaulipas', 'learning-management-system' ),
		'TL' => __( 'Tlaxcala', 'learning-management-system' ),
		'VE' => __( 'Veracruz', 'learning-management-system' ),
		'YU' => __( 'Yucatán', 'learning-management-system' ),
		'ZA' => __( 'Zacatecas', 'learning-management-system' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'learning-management-system' ),
		'KDH' => __( 'Kedah', 'learning-management-system' ),
		'KTN' => __( 'Kelantan', 'learning-management-system' ),
		'LBN' => __( 'Labuan', 'learning-management-system' ),
		'MLK' => __( 'Malacca (Melaka)', 'learning-management-system' ),
		'NSN' => __( 'Negeri Sembilan', 'learning-management-system' ),
		'PHG' => __( 'Pahang', 'learning-management-system' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'learning-management-system' ),
		'PRK' => __( 'Perak', 'learning-management-system' ),
		'PLS' => __( 'Perlis', 'learning-management-system' ),
		'SBH' => __( 'Sabah', 'learning-management-system' ),
		'SWK' => __( 'Sarawak', 'learning-management-system' ),
		'SGR' => __( 'Selangor', 'learning-management-system' ),
		'TRG' => __( 'Terengganu', 'learning-management-system' ),
		'PJY' => __( 'Putrajaya', 'learning-management-system' ),
		'KUL' => __( 'Kuala Lumpur', 'learning-management-system' ),
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'learning-management-system' ),
		'MZG'   => __( 'Gaza', 'learning-management-system' ),
		'MZI'   => __( 'Inhambane', 'learning-management-system' ),
		'MZB'   => __( 'Manica', 'learning-management-system' ),
		'MZL'   => __( 'Maputo Province', 'learning-management-system' ),
		'MZMPM' => __( 'Maputo', 'learning-management-system' ),
		'MZN'   => __( 'Nampula', 'learning-management-system' ),
		'MZA'   => __( 'Niassa', 'learning-management-system' ),
		'MZS'   => __( 'Sofala', 'learning-management-system' ),
		'MZT'   => __( 'Tete', 'learning-management-system' ),
		'MZQ'   => __( 'Zambézia', 'learning-management-system' ),
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'learning-management-system' ),
		'HA' => __( 'Hardap', 'learning-management-system' ),
		'KA' => __( 'Karas', 'learning-management-system' ),
		'KE' => __( 'Kavango East', 'learning-management-system' ),
		'KW' => __( 'Kavango West', 'learning-management-system' ),
		'KH' => __( 'Khomas', 'learning-management-system' ),
		'KU' => __( 'Kunene', 'learning-management-system' ),
		'OW' => __( 'Ohangwena', 'learning-management-system' ),
		'OH' => __( 'Omaheke', 'learning-management-system' ),
		'OS' => __( 'Omusati', 'learning-management-system' ),
		'ON' => __( 'Oshana', 'learning-management-system' ),
		'OT' => __( 'Oshikoto', 'learning-management-system' ),
		'OD' => __( 'Otjozondjupa', 'learning-management-system' ),
		'CA' => __( 'Zambezi', 'learning-management-system' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'learning-management-system' ),
		'FC' => __( 'Abuja', 'learning-management-system' ),
		'AD' => __( 'Adamawa', 'learning-management-system' ),
		'AK' => __( 'Akwa Ibom', 'learning-management-system' ),
		'AN' => __( 'Anambra', 'learning-management-system' ),
		'BA' => __( 'Bauchi', 'learning-management-system' ),
		'BY' => __( 'Bayelsa', 'learning-management-system' ),
		'BE' => __( 'Benue', 'learning-management-system' ),
		'BO' => __( 'Borno', 'learning-management-system' ),
		'CR' => __( 'Cross River', 'learning-management-system' ),
		'DE' => __( 'Delta', 'learning-management-system' ),
		'EB' => __( 'Ebonyi', 'learning-management-system' ),
		'ED' => __( 'Edo', 'learning-management-system' ),
		'EK' => __( 'Ekiti', 'learning-management-system' ),
		'EN' => __( 'Enugu', 'learning-management-system' ),
		'GO' => __( 'Gombe', 'learning-management-system' ),
		'IM' => __( 'Imo', 'learning-management-system' ),
		'JI' => __( 'Jigawa', 'learning-management-system' ),
		'KD' => __( 'Kaduna', 'learning-management-system' ),
		'KN' => __( 'Kano', 'learning-management-system' ),
		'KT' => __( 'Katsina', 'learning-management-system' ),
		'KE' => __( 'Kebbi', 'learning-management-system' ),
		'KO' => __( 'Kogi', 'learning-management-system' ),
		'KW' => __( 'Kwara', 'learning-management-system' ),
		'LA' => __( 'Lagos', 'learning-management-system' ),
		'NA' => __( 'Nasarawa', 'learning-management-system' ),
		'NI' => __( 'Niger', 'learning-management-system' ),
		'OG' => __( 'Ogun', 'learning-management-system' ),
		'ON' => __( 'Ondo', 'learning-management-system' ),
		'OS' => __( 'Osun', 'learning-management-system' ),
		'OY' => __( 'Oyo', 'learning-management-system' ),
		'PL' => __( 'Plateau', 'learning-management-system' ),
		'RI' => __( 'Rivers', 'learning-management-system' ),
		'SO' => __( 'Sokoto', 'learning-management-system' ),
		'TA' => __( 'Taraba', 'learning-management-system' ),
		'YO' => __( 'Yobe', 'learning-management-system' ),
		'ZA' => __( 'Zamfara', 'learning-management-system' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'learning-management-system' ),
		'BHE' => __( 'Bheri', 'learning-management-system' ),
		'DHA' => __( 'Dhaulagiri', 'learning-management-system' ),
		'GAN' => __( 'Gandaki', 'learning-management-system' ),
		'JAN' => __( 'Janakpur', 'learning-management-system' ),
		'KAR' => __( 'Karnali', 'learning-management-system' ),
		'KOS' => __( 'Koshi', 'learning-management-system' ),
		'LUM' => __( 'Lumbini', 'learning-management-system' ),
		'MAH' => __( 'Mahakali', 'learning-management-system' ),
		'MEC' => __( 'Mechi', 'learning-management-system' ),
		'NAR' => __( 'Narayani', 'learning-management-system' ),
		'RAP' => __( 'Rapti', 'learning-management-system' ),
		'SAG' => __( 'Sagarmatha', 'learning-management-system' ),
		'SET' => __( 'Seti', 'learning-management-system' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'learning-management-system' ),
		'AK' => __( 'Auckland', 'learning-management-system' ),
		'WA' => __( 'Waikato', 'learning-management-system' ),
		'BP' => __( 'Bay of Plenty', 'learning-management-system' ),
		'TK' => __( 'Taranaki', 'learning-management-system' ),
		'GI' => __( 'Gisborne', 'learning-management-system' ),
		'HB' => __( 'Hawke’s Bay', 'learning-management-system' ),
		'MW' => __( 'Manawatu-Wanganui', 'learning-management-system' ),
		'WE' => __( 'Wellington', 'learning-management-system' ),
		'NS' => __( 'Nelson', 'learning-management-system' ),
		'MB' => __( 'Marlborough', 'learning-management-system' ),
		'TM' => __( 'Tasman', 'learning-management-system' ),
		'WC' => __( 'West Coast', 'learning-management-system' ),
		'CT' => __( 'Canterbury', 'learning-management-system' ),
		'OT' => __( 'Otago', 'learning-management-system' ),
		'SL' => __( 'Southland', 'learning-management-system' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'learning-management-system' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'learning-management-system' ),
		'AMA' => __( 'Amazonas', 'learning-management-system' ),
		'ANC' => __( 'Ancash', 'learning-management-system' ),
		'APU' => __( 'Apurímac', 'learning-management-system' ),
		'ARE' => __( 'Arequipa', 'learning-management-system' ),
		'AYA' => __( 'Ayacucho', 'learning-management-system' ),
		'CAJ' => __( 'Cajamarca', 'learning-management-system' ),
		'CUS' => __( 'Cusco', 'learning-management-system' ),
		'HUV' => __( 'Huancavelica', 'learning-management-system' ),
		'HUC' => __( 'Huánuco', 'learning-management-system' ),
		'ICA' => __( 'Ica', 'learning-management-system' ),
		'JUN' => __( 'Junín', 'learning-management-system' ),
		'LAL' => __( 'La Libertad', 'learning-management-system' ),
		'LAM' => __( 'Lambayeque', 'learning-management-system' ),
		'LIM' => __( 'Lima', 'learning-management-system' ),
		'LOR' => __( 'Loreto', 'learning-management-system' ),
		'MDD' => __( 'Madre de Dios', 'learning-management-system' ),
		'MOQ' => __( 'Moquegua', 'learning-management-system' ),
		'PAS' => __( 'Pasco', 'learning-management-system' ),
		'PIU' => __( 'Piura', 'learning-management-system' ),
		'PUN' => __( 'Puno', 'learning-management-system' ),
		'SAM' => __( 'San Martín', 'learning-management-system' ),
		'TAC' => __( 'Tacna', 'learning-management-system' ),
		'TUM' => __( 'Tumbes', 'learning-management-system' ),
		'UCA' => __( 'Ucayali', 'learning-management-system' ),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'learning-management-system' ),
		'AGN' => __( 'Agusan del Norte', 'learning-management-system' ),
		'AGS' => __( 'Agusan del Sur', 'learning-management-system' ),
		'AKL' => __( 'Aklan', 'learning-management-system' ),
		'ALB' => __( 'Albay', 'learning-management-system' ),
		'ANT' => __( 'Antique', 'learning-management-system' ),
		'APA' => __( 'Apayao', 'learning-management-system' ),
		'AUR' => __( 'Aurora', 'learning-management-system' ),
		'BAS' => __( 'Basilan', 'learning-management-system' ),
		'BAN' => __( 'Bataan', 'learning-management-system' ),
		'BTN' => __( 'Batanes', 'learning-management-system' ),
		'BTG' => __( 'Batangas', 'learning-management-system' ),
		'BEN' => __( 'Benguet', 'learning-management-system' ),
		'BIL' => __( 'Biliran', 'learning-management-system' ),
		'BOH' => __( 'Bohol', 'learning-management-system' ),
		'BUK' => __( 'Bukidnon', 'learning-management-system' ),
		'BUL' => __( 'Bulacan', 'learning-management-system' ),
		'CAG' => __( 'Cagayan', 'learning-management-system' ),
		'CAN' => __( 'Camarines Norte', 'learning-management-system' ),
		'CAS' => __( 'Camarines Sur', 'learning-management-system' ),
		'CAM' => __( 'Camiguin', 'learning-management-system' ),
		'CAP' => __( 'Capiz', 'learning-management-system' ),
		'CAT' => __( 'Catanduanes', 'learning-management-system' ),
		'CAV' => __( 'Cavite', 'learning-management-system' ),
		'CEB' => __( 'Cebu', 'learning-management-system' ),
		'COM' => __( 'Compostela Valley', 'learning-management-system' ),
		'NCO' => __( 'Cotabato', 'learning-management-system' ),
		'DAV' => __( 'Davao del Norte', 'learning-management-system' ),
		'DAS' => __( 'Davao del Sur', 'learning-management-system' ),
		'DAC' => __( 'Davao Occidental', 'learning-management-system' ),
		'DAO' => __( 'Davao Oriental', 'learning-management-system' ),
		'DIN' => __( 'Dinagat Islands', 'learning-management-system' ),
		'EAS' => __( 'Eastern Samar', 'learning-management-system' ),
		'GUI' => __( 'Guimaras', 'learning-management-system' ),
		'IFU' => __( 'Ifugao', 'learning-management-system' ),
		'ILN' => __( 'Ilocos Norte', 'learning-management-system' ),
		'ILS' => __( 'Ilocos Sur', 'learning-management-system' ),
		'ILI' => __( 'Iloilo', 'learning-management-system' ),
		'ISA' => __( 'Isabela', 'learning-management-system' ),
		'KAL' => __( 'Kalinga', 'learning-management-system' ),
		'LUN' => __( 'La Union', 'learning-management-system' ),
		'LAG' => __( 'Laguna', 'learning-management-system' ),
		'LAN' => __( 'Lanao del Norte', 'learning-management-system' ),
		'LAS' => __( 'Lanao del Sur', 'learning-management-system' ),
		'LEY' => __( 'Leyte', 'learning-management-system' ),
		'MAG' => __( 'Maguindanao', 'learning-management-system' ),
		'MAD' => __( 'Marinduque', 'learning-management-system' ),
		'MAS' => __( 'Masbate', 'learning-management-system' ),
		'MSC' => __( 'Misamis Occidental', 'learning-management-system' ),
		'MSR' => __( 'Misamis Oriental', 'learning-management-system' ),
		'MOU' => __( 'Mountain Province', 'learning-management-system' ),
		'NEC' => __( 'Negros Occidental', 'learning-management-system' ),
		'NER' => __( 'Negros Oriental', 'learning-management-system' ),
		'NSA' => __( 'Northern Samar', 'learning-management-system' ),
		'NUE' => __( 'Nueva Ecija', 'learning-management-system' ),
		'NUV' => __( 'Nueva Vizcaya', 'learning-management-system' ),
		'MDC' => __( 'Occidental Mindoro', 'learning-management-system' ),
		'MDR' => __( 'Oriental Mindoro', 'learning-management-system' ),
		'PLW' => __( 'Palawan', 'learning-management-system' ),
		'PAM' => __( 'Pampanga', 'learning-management-system' ),
		'PAN' => __( 'Pangasinan', 'learning-management-system' ),
		'QUE' => __( 'Quezon', 'learning-management-system' ),
		'QUI' => __( 'Quirino', 'learning-management-system' ),
		'RIZ' => __( 'Rizal', 'learning-management-system' ),
		'ROM' => __( 'Romblon', 'learning-management-system' ),
		'WSA' => __( 'Samar', 'learning-management-system' ),
		'SAR' => __( 'Sarangani', 'learning-management-system' ),
		'SIQ' => __( 'Siquijor', 'learning-management-system' ),
		'SOR' => __( 'Sorsogon', 'learning-management-system' ),
		'SCO' => __( 'South Cotabato', 'learning-management-system' ),
		'SLE' => __( 'Southern Leyte', 'learning-management-system' ),
		'SUK' => __( 'Sultan Kudarat', 'learning-management-system' ),
		'SLU' => __( 'Sulu', 'learning-management-system' ),
		'SUN' => __( 'Surigao del Norte', 'learning-management-system' ),
		'SUR' => __( 'Surigao del Sur', 'learning-management-system' ),
		'TAR' => __( 'Tarlac', 'learning-management-system' ),
		'TAW' => __( 'Tawi-Tawi', 'learning-management-system' ),
		'ZMB' => __( 'Zambales', 'learning-management-system' ),
		'ZAN' => __( 'Zamboanga del Norte', 'learning-management-system' ),
		'ZAS' => __( 'Zamboanga del Sur', 'learning-management-system' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'learning-management-system' ),
		'00'  => __( 'Metro Manila', 'learning-management-system' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'learning-management-system' ),
		'BA' => __( 'Balochistan', 'learning-management-system' ),
		'TA' => __( 'FATA', 'learning-management-system' ),
		'GB' => __( 'Gilgit Baltistan', 'learning-management-system' ),
		'IS' => __( 'Islamabad Capital Territory', 'learning-management-system' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'learning-management-system' ),
		'PB' => __( 'Punjab', 'learning-management-system' ),
		'SD' => __( 'Sindh', 'learning-management-system' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'learning-management-system' ),
		'PY-1'   => __( 'Concepción', 'learning-management-system' ),
		'PY-2'   => __( 'San Pedro', 'learning-management-system' ),
		'PY-3'   => __( 'Cordillera', 'learning-management-system' ),
		'PY-4'   => __( 'Guairá', 'learning-management-system' ),
		'PY-5'   => __( 'Caaguazú', 'learning-management-system' ),
		'PY-6'   => __( 'Caazapá', 'learning-management-system' ),
		'PY-7'   => __( 'Itapúa', 'learning-management-system' ),
		'PY-8'   => __( 'Misiones', 'learning-management-system' ),
		'PY-9'   => __( 'Paraguarí', 'learning-management-system' ),
		'PY-10'  => __( 'Alto Paraná', 'learning-management-system' ),
		'PY-11'  => __( 'Central', 'learning-management-system' ),
		'PY-12'  => __( 'Ñeembucú', 'learning-management-system' ),
		'PY-13'  => __( 'Amambay', 'learning-management-system' ),
		'PY-14'  => __( 'Canindeyú', 'learning-management-system' ),
		'PY-15'  => __( 'Presidente Hayes', 'learning-management-system' ),
		'PY-16'  => __( 'Alto Paraguay', 'learning-management-system' ),
		'PY-17'  => __( 'Boquerón', 'learning-management-system' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'learning-management-system' ),
		'AR' => __( 'Arad', 'learning-management-system' ),
		'AG' => __( 'Argeș', 'learning-management-system' ),
		'BC' => __( 'Bacău', 'learning-management-system' ),
		'BH' => __( 'Bihor', 'learning-management-system' ),
		'BN' => __( 'Bistrița-Năsăud', 'learning-management-system' ),
		'BT' => __( 'Botoșani', 'learning-management-system' ),
		'BR' => __( 'Brăila', 'learning-management-system' ),
		'BV' => __( 'Brașov', 'learning-management-system' ),
		'B'  => __( 'București', 'learning-management-system' ),
		'BZ' => __( 'Buzău', 'learning-management-system' ),
		'CL' => __( 'Călărași', 'learning-management-system' ),
		'CS' => __( 'Caraș-Severin', 'learning-management-system' ),
		'CJ' => __( 'Cluj', 'learning-management-system' ),
		'CT' => __( 'Constanța', 'learning-management-system' ),
		'CV' => __( 'Covasna', 'learning-management-system' ),
		'DB' => __( 'Dâmbovița', 'learning-management-system' ),
		'DJ' => __( 'Dolj', 'learning-management-system' ),
		'GL' => __( 'Galați', 'learning-management-system' ),
		'GR' => __( 'Giurgiu', 'learning-management-system' ),
		'GJ' => __( 'Gorj', 'learning-management-system' ),
		'HR' => __( 'Harghita', 'learning-management-system' ),
		'HD' => __( 'Hunedoara', 'learning-management-system' ),
		'IL' => __( 'Ialomița', 'learning-management-system' ),
		'IS' => __( 'Iași', 'learning-management-system' ),
		'IF' => __( 'Ilfov', 'learning-management-system' ),
		'MM' => __( 'Maramureș', 'learning-management-system' ),
		'MH' => __( 'Mehedinți', 'learning-management-system' ),
		'MS' => __( 'Mureș', 'learning-management-system' ),
		'NT' => __( 'Neamț', 'learning-management-system' ),
		'OT' => __( 'Olt', 'learning-management-system' ),
		'PH' => __( 'Prahova', 'learning-management-system' ),
		'SJ' => __( 'Sălaj', 'learning-management-system' ),
		'SM' => __( 'Satu Mare', 'learning-management-system' ),
		'SB' => __( 'Sibiu', 'learning-management-system' ),
		'SV' => __( 'Suceava', 'learning-management-system' ),
		'TR' => __( 'Teleorman', 'learning-management-system' ),
		'TM' => __( 'Timiș', 'learning-management-system' ),
		'TL' => __( 'Tulcea', 'learning-management-system' ),
		'VL' => __( 'Vâlcea', 'learning-management-system' ),
		'VS' => __( 'Vaslui', 'learning-management-system' ),
		'VN' => __( 'Vrancea', 'learning-management-system' ),
	),
	'RS' => array(),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'learning-management-system' ),
		'TH-15' => __( 'Ang Thong', 'learning-management-system' ),
		'TH-14' => __( 'Ayutthaya', 'learning-management-system' ),
		'TH-10' => __( 'Bangkok', 'learning-management-system' ),
		'TH-38' => __( 'Bueng Kan', 'learning-management-system' ),
		'TH-31' => __( 'Buri Ram', 'learning-management-system' ),
		'TH-24' => __( 'Chachoengsao', 'learning-management-system' ),
		'TH-18' => __( 'Chai Nat', 'learning-management-system' ),
		'TH-36' => __( 'Chaiyaphum', 'learning-management-system' ),
		'TH-22' => __( 'Chanthaburi', 'learning-management-system' ),
		'TH-50' => __( 'Chiang Mai', 'learning-management-system' ),
		'TH-57' => __( 'Chiang Rai', 'learning-management-system' ),
		'TH-20' => __( 'Chonburi', 'learning-management-system' ),
		'TH-86' => __( 'Chumphon', 'learning-management-system' ),
		'TH-46' => __( 'Kalasin', 'learning-management-system' ),
		'TH-62' => __( 'Kamphaeng Phet', 'learning-management-system' ),
		'TH-71' => __( 'Kanchanaburi', 'learning-management-system' ),
		'TH-40' => __( 'Khon Kaen', 'learning-management-system' ),
		'TH-81' => __( 'Krabi', 'learning-management-system' ),
		'TH-52' => __( 'Lampang', 'learning-management-system' ),
		'TH-51' => __( 'Lamphun', 'learning-management-system' ),
		'TH-42' => __( 'Loei', 'learning-management-system' ),
		'TH-16' => __( 'Lopburi', 'learning-management-system' ),
		'TH-58' => __( 'Mae Hong Son', 'learning-management-system' ),
		'TH-44' => __( 'Maha Sarakham', 'learning-management-system' ),
		'TH-49' => __( 'Mukdahan', 'learning-management-system' ),
		'TH-26' => __( 'Nakhon Nayok', 'learning-management-system' ),
		'TH-73' => __( 'Nakhon Pathom', 'learning-management-system' ),
		'TH-48' => __( 'Nakhon Phanom', 'learning-management-system' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'learning-management-system' ),
		'TH-60' => __( 'Nakhon Sawan', 'learning-management-system' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'learning-management-system' ),
		'TH-55' => __( 'Nan', 'learning-management-system' ),
		'TH-96' => __( 'Narathiwat', 'learning-management-system' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'learning-management-system' ),
		'TH-43' => __( 'Nong Khai', 'learning-management-system' ),
		'TH-12' => __( 'Nonthaburi', 'learning-management-system' ),
		'TH-13' => __( 'Pathum Thani', 'learning-management-system' ),
		'TH-94' => __( 'Pattani', 'learning-management-system' ),
		'TH-82' => __( 'Phang Nga', 'learning-management-system' ),
		'TH-93' => __( 'Phatthalung', 'learning-management-system' ),
		'TH-56' => __( 'Phayao', 'learning-management-system' ),
		'TH-67' => __( 'Phetchabun', 'learning-management-system' ),
		'TH-76' => __( 'Phetchaburi', 'learning-management-system' ),
		'TH-66' => __( 'Phichit', 'learning-management-system' ),
		'TH-65' => __( 'Phitsanulok', 'learning-management-system' ),
		'TH-54' => __( 'Phrae', 'learning-management-system' ),
		'TH-83' => __( 'Phuket', 'learning-management-system' ),
		'TH-25' => __( 'Prachin Buri', 'learning-management-system' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'learning-management-system' ),
		'TH-85' => __( 'Ranong', 'learning-management-system' ),
		'TH-70' => __( 'Ratchaburi', 'learning-management-system' ),
		'TH-21' => __( 'Rayong', 'learning-management-system' ),
		'TH-45' => __( 'Roi Et', 'learning-management-system' ),
		'TH-27' => __( 'Sa Kaeo', 'learning-management-system' ),
		'TH-47' => __( 'Sakon Nakhon', 'learning-management-system' ),
		'TH-11' => __( 'Samut Prakan', 'learning-management-system' ),
		'TH-74' => __( 'Samut Sakhon', 'learning-management-system' ),
		'TH-75' => __( 'Samut Songkhram', 'learning-management-system' ),
		'TH-19' => __( 'Saraburi', 'learning-management-system' ),
		'TH-91' => __( 'Satun', 'learning-management-system' ),
		'TH-17' => __( 'Sing Buri', 'learning-management-system' ),
		'TH-33' => __( 'Sisaket', 'learning-management-system' ),
		'TH-90' => __( 'Songkhla', 'learning-management-system' ),
		'TH-64' => __( 'Sukhothai', 'learning-management-system' ),
		'TH-72' => __( 'Suphan Buri', 'learning-management-system' ),
		'TH-84' => __( 'Surat Thani', 'learning-management-system' ),
		'TH-32' => __( 'Surin', 'learning-management-system' ),
		'TH-63' => __( 'Tak', 'learning-management-system' ),
		'TH-92' => __( 'Trang', 'learning-management-system' ),
		'TH-23' => __( 'Trat', 'learning-management-system' ),
		'TH-34' => __( 'Ubon Ratchathani', 'learning-management-system' ),
		'TH-41' => __( 'Udon Thani', 'learning-management-system' ),
		'TH-61' => __( 'Uthai Thani', 'learning-management-system' ),
		'TH-53' => __( 'Uttaradit', 'learning-management-system' ),
		'TH-95' => __( 'Yala', 'learning-management-system' ),
		'TH-35' => __( 'Yasothon', 'learning-management-system' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'learning-management-system' ),
		'TR02' => __( 'Adıyaman', 'learning-management-system' ),
		'TR03' => __( 'Afyon', 'learning-management-system' ),
		'TR04' => __( 'Ağrı', 'learning-management-system' ),
		'TR05' => __( 'Amasya', 'learning-management-system' ),
		'TR06' => __( 'Ankara', 'learning-management-system' ),
		'TR07' => __( 'Antalya', 'learning-management-system' ),
		'TR08' => __( 'Artvin', 'learning-management-system' ),
		'TR09' => __( 'Aydın', 'learning-management-system' ),
		'TR10' => __( 'Balıkesir', 'learning-management-system' ),
		'TR11' => __( 'Bilecik', 'learning-management-system' ),
		'TR12' => __( 'Bingöl', 'learning-management-system' ),
		'TR13' => __( 'Bitlis', 'learning-management-system' ),
		'TR14' => __( 'Bolu', 'learning-management-system' ),
		'TR15' => __( 'Burdur', 'learning-management-system' ),
		'TR16' => __( 'Bursa', 'learning-management-system' ),
		'TR17' => __( 'Çanakkale', 'learning-management-system' ),
		'TR18' => __( 'Çankırı', 'learning-management-system' ),
		'TR19' => __( 'Çorum', 'learning-management-system' ),
		'TR20' => __( 'Denizli', 'learning-management-system' ),
		'TR21' => __( 'Diyarbakır', 'learning-management-system' ),
		'TR22' => __( 'Edirne', 'learning-management-system' ),
		'TR23' => __( 'Elazığ', 'learning-management-system' ),
		'TR24' => __( 'Erzincan', 'learning-management-system' ),
		'TR25' => __( 'Erzurum', 'learning-management-system' ),
		'TR26' => __( 'Eskişehir', 'learning-management-system' ),
		'TR27' => __( 'Gaziantep', 'learning-management-system' ),
		'TR28' => __( 'Giresun', 'learning-management-system' ),
		'TR29' => __( 'Gümüşhane', 'learning-management-system' ),
		'TR30' => __( 'Hakkari', 'learning-management-system' ),
		'TR31' => __( 'Hatay', 'learning-management-system' ),
		'TR32' => __( 'Isparta', 'learning-management-system' ),
		'TR33' => __( 'İçel', 'learning-management-system' ),
		'TR34' => __( 'İstanbul', 'learning-management-system' ),
		'TR35' => __( 'İzmir', 'learning-management-system' ),
		'TR36' => __( 'Kars', 'learning-management-system' ),
		'TR37' => __( 'Kastamonu', 'learning-management-system' ),
		'TR38' => __( 'Kayseri', 'learning-management-system' ),
		'TR39' => __( 'Kırklareli', 'learning-management-system' ),
		'TR40' => __( 'Kırşehir', 'learning-management-system' ),
		'TR41' => __( 'Kocaeli', 'learning-management-system' ),
		'TR42' => __( 'Konya', 'learning-management-system' ),
		'TR43' => __( 'Kütahya', 'learning-management-system' ),
		'TR44' => __( 'Malatya', 'learning-management-system' ),
		'TR45' => __( 'Manisa', 'learning-management-system' ),
		'TR46' => __( 'Kahramanmaraş', 'learning-management-system' ),
		'TR47' => __( 'Mardin', 'learning-management-system' ),
		'TR48' => __( 'Muğla', 'learning-management-system' ),
		'TR49' => __( 'Muş', 'learning-management-system' ),
		'TR50' => __( 'Nevşehir', 'learning-management-system' ),
		'TR51' => __( 'Niğde', 'learning-management-system' ),
		'TR52' => __( 'Ordu', 'learning-management-system' ),
		'TR53' => __( 'Rize', 'learning-management-system' ),
		'TR54' => __( 'Sakarya', 'learning-management-system' ),
		'TR55' => __( 'Samsun', 'learning-management-system' ),
		'TR56' => __( 'Siirt', 'learning-management-system' ),
		'TR57' => __( 'Sinop', 'learning-management-system' ),
		'TR58' => __( 'Sivas', 'learning-management-system' ),
		'TR59' => __( 'Tekirdağ', 'learning-management-system' ),
		'TR60' => __( 'Tokat', 'learning-management-system' ),
		'TR61' => __( 'Trabzon', 'learning-management-system' ),
		'TR62' => __( 'Tunceli', 'learning-management-system' ),
		'TR63' => __( 'Şanlıurfa', 'learning-management-system' ),
		'TR64' => __( 'Uşak', 'learning-management-system' ),
		'TR65' => __( 'Van', 'learning-management-system' ),
		'TR66' => __( 'Yozgat', 'learning-management-system' ),
		'TR67' => __( 'Zonguldak', 'learning-management-system' ),
		'TR68' => __( 'Aksaray', 'learning-management-system' ),
		'TR69' => __( 'Bayburt', 'learning-management-system' ),
		'TR70' => __( 'Karaman', 'learning-management-system' ),
		'TR71' => __( 'Kırıkkale', 'learning-management-system' ),
		'TR72' => __( 'Batman', 'learning-management-system' ),
		'TR73' => __( 'Şırnak', 'learning-management-system' ),
		'TR74' => __( 'Bartın', 'learning-management-system' ),
		'TR75' => __( 'Ardahan', 'learning-management-system' ),
		'TR76' => __( 'Iğdır', 'learning-management-system' ),
		'TR77' => __( 'Yalova', 'learning-management-system' ),
		'TR78' => __( 'Karabük', 'learning-management-system' ),
		'TR79' => __( 'Kilis', 'learning-management-system' ),
		'TR80' => __( 'Osmaniye', 'learning-management-system' ),
		'TR81' => __( 'Düzce', 'learning-management-system' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'learning-management-system' ),
		'TZ02' => __( 'Dar es Salaam', 'learning-management-system' ),
		'TZ03' => __( 'Dodoma', 'learning-management-system' ),
		'TZ04' => __( 'Iringa', 'learning-management-system' ),
		'TZ05' => __( 'Kagera', 'learning-management-system' ),
		'TZ06' => __( 'Pemba North', 'learning-management-system' ),
		'TZ07' => __( 'Zanzibar North', 'learning-management-system' ),
		'TZ08' => __( 'Kigoma', 'learning-management-system' ),
		'TZ09' => __( 'Kilimanjaro', 'learning-management-system' ),
		'TZ10' => __( 'Pemba South', 'learning-management-system' ),
		'TZ11' => __( 'Zanzibar South', 'learning-management-system' ),
		'TZ12' => __( 'Lindi', 'learning-management-system' ),
		'TZ13' => __( 'Mara', 'learning-management-system' ),
		'TZ14' => __( 'Mbeya', 'learning-management-system' ),
		'TZ15' => __( 'Zanzibar West', 'learning-management-system' ),
		'TZ16' => __( 'Morogoro', 'learning-management-system' ),
		'TZ17' => __( 'Mtwara', 'learning-management-system' ),
		'TZ18' => __( 'Mwanza', 'learning-management-system' ),
		'TZ19' => __( 'Coast', 'learning-management-system' ),
		'TZ20' => __( 'Rukwa', 'learning-management-system' ),
		'TZ21' => __( 'Ruvuma', 'learning-management-system' ),
		'TZ22' => __( 'Shinyanga', 'learning-management-system' ),
		'TZ23' => __( 'Singida', 'learning-management-system' ),
		'TZ24' => __( 'Tabora', 'learning-management-system' ),
		'TZ25' => __( 'Tanga', 'learning-management-system' ),
		'TZ26' => __( 'Manyara', 'learning-management-system' ),
		'TZ27' => __( 'Geita', 'learning-management-system' ),
		'TZ28' => __( 'Katavi', 'learning-management-system' ),
		'TZ29' => __( 'Njombe', 'learning-management-system' ),
		'TZ30' => __( 'Simiyu', 'learning-management-system' ),
	),
	'LK' => array(),
	'RS' => array( // Serbia districts Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
		'RS00' => _x( 'Belgrade', 'district', 'learning-management-system' ),
		'RS14' => _x( 'Bor', 'district', 'learning-management-system' ),
		'RS11' => _x( 'Braničevo', 'district', 'learning-management-system' ),
		'RS02' => _x( 'Central Banat', 'district', 'learning-management-system' ),
		'RS10' => _x( 'Danube', 'district', 'learning-management-system' ),
		'RS23' => _x( 'Jablanica', 'district', 'learning-management-system' ),
		'RS09' => _x( 'Kolubara', 'district', 'learning-management-system' ),
		'RS08' => _x( 'Mačva', 'district', 'learning-management-system' ),
		'RS17' => _x( 'Morava', 'district', 'learning-management-system' ),
		'RS20' => _x( 'Nišava', 'district', 'learning-management-system' ),
		'RS01' => _x( 'North Bačka', 'district', 'learning-management-system' ),
		'RS03' => _x( 'North Banat', 'district', 'learning-management-system' ),
		'RS24' => _x( 'Pčinja', 'district', 'learning-management-system' ),
		'RS22' => _x( 'Pirot', 'district', 'learning-management-system' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'learning-management-system' ),
		'RS19' => _x( 'Rasina', 'district', 'learning-management-system' ),
		'RS18' => _x( 'Raška', 'district', 'learning-management-system' ),
		'RS06' => _x( 'South Bačka', 'district', 'learning-management-system' ),
		'RS04' => _x( 'South Banat', 'district', 'learning-management-system' ),
		'RS07' => _x( 'Srem', 'district', 'learning-management-system' ),
		'RS12' => _x( 'Šumadija', 'district', 'learning-management-system' ),
		'RS21' => _x( 'Toplica', 'district', 'learning-management-system' ),
		'RS05' => _x( 'West Bačka', 'district', 'learning-management-system' ),
		'RS15' => _x( 'Zaječar', 'district', 'learning-management-system' ),
		'RS16' => _x( 'Zlatibor', 'district', 'learning-management-system' ),
		'RS25' => _x( 'Kosovo', 'district', 'learning-management-system' ),
		'RS26' => _x( 'Peć', 'district', 'learning-management-system' ),
		'RS27' => _x( 'Prizren', 'district', 'learning-management-system' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'learning-management-system' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'learning-management-system' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'learning-management-system' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'learning-management-system' ),
	),
	'SE' => array(),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'learning-management-system' ),
		'UG301' => __( 'Adjumani', 'learning-management-system' ),
		'UG322' => __( 'Agago', 'learning-management-system' ),
		'UG323' => __( 'Alebtong', 'learning-management-system' ),
		'UG315' => __( 'Amolatar', 'learning-management-system' ),
		'UG324' => __( 'Amudat', 'learning-management-system' ),
		'UG216' => __( 'Amuria', 'learning-management-system' ),
		'UG316' => __( 'Amuru', 'learning-management-system' ),
		'UG302' => __( 'Apac', 'learning-management-system' ),
		'UG303' => __( 'Arua', 'learning-management-system' ),
		'UG217' => __( 'Budaka', 'learning-management-system' ),
		'UG218' => __( 'Bududa', 'learning-management-system' ),
		'UG201' => __( 'Bugiri', 'learning-management-system' ),
		'UG235' => __( 'Bugweri', 'learning-management-system' ),
		'UG420' => __( 'Buhweju', 'learning-management-system' ),
		'UG117' => __( 'Buikwe', 'learning-management-system' ),
		'UG219' => __( 'Bukedea', 'learning-management-system' ),
		'UG118' => __( 'Bukomansimbi', 'learning-management-system' ),
		'UG220' => __( 'Bukwa', 'learning-management-system' ),
		'UG225' => __( 'Bulambuli', 'learning-management-system' ),
		'UG416' => __( 'Buliisa', 'learning-management-system' ),
		'UG401' => __( 'Bundibugyo', 'learning-management-system' ),
		'UG430' => __( 'Bunyangabu', 'learning-management-system' ),
		'UG402' => __( 'Bushenyi', 'learning-management-system' ),
		'UG202' => __( 'Busia', 'learning-management-system' ),
		'UG221' => __( 'Butaleja', 'learning-management-system' ),
		'UG119' => __( 'Butambala', 'learning-management-system' ),
		'UG233' => __( 'Butebo', 'learning-management-system' ),
		'UG120' => __( 'Buvuma', 'learning-management-system' ),
		'UG226' => __( 'Buyende', 'learning-management-system' ),
		'UG317' => __( 'Dokolo', 'learning-management-system' ),
		'UG121' => __( 'Gomba', 'learning-management-system' ),
		'UG304' => __( 'Gulu', 'learning-management-system' ),
		'UG403' => __( 'Hoima', 'learning-management-system' ),
		'UG417' => __( 'Ibanda', 'learning-management-system' ),
		'UG203' => __( 'Iganga', 'learning-management-system' ),
		'UG418' => __( 'Isingiro', 'learning-management-system' ),
		'UG204' => __( 'Jinja', 'learning-management-system' ),
		'UG318' => __( 'Kaabong', 'learning-management-system' ),
		'UG404' => __( 'Kabale', 'learning-management-system' ),
		'UG405' => __( 'Kabarole', 'learning-management-system' ),
		'UG213' => __( 'Kaberamaido', 'learning-management-system' ),
		'UG427' => __( 'Kagadi', 'learning-management-system' ),
		'UG428' => __( 'Kakumiro', 'learning-management-system' ),
		'UG101' => __( 'Kalangala', 'learning-management-system' ),
		'UG222' => __( 'Kaliro', 'learning-management-system' ),
		'UG122' => __( 'Kalungu', 'learning-management-system' ),
		'UG102' => __( 'Kampala', 'learning-management-system' ),
		'UG205' => __( 'Kamuli', 'learning-management-system' ),
		'UG413' => __( 'Kamwenge', 'learning-management-system' ),
		'UG414' => __( 'Kanungu', 'learning-management-system' ),
		'UG206' => __( 'Kapchorwa', 'learning-management-system' ),
		'UG236' => __( 'Kapelebyong', 'learning-management-system' ),
		'UG126' => __( 'Kasanda', 'learning-management-system' ),
		'UG406' => __( 'Kasese', 'learning-management-system' ),
		'UG207' => __( 'Katakwi', 'learning-management-system' ),
		'UG112' => __( 'Kayunga', 'learning-management-system' ),
		'UG407' => __( 'Kibaale', 'learning-management-system' ),
		'UG103' => __( 'Kiboga', 'learning-management-system' ),
		'UG227' => __( 'Kibuku', 'learning-management-system' ),
		'UG432' => __( 'Kikuube', 'learning-management-system' ),
		'UG419' => __( 'Kiruhura', 'learning-management-system' ),
		'UG421' => __( 'Kiryandongo', 'learning-management-system' ),
		'UG408' => __( 'Kisoro', 'learning-management-system' ),
		'UG305' => __( 'Kitgum', 'learning-management-system' ),
		'UG319' => __( 'Koboko', 'learning-management-system' ),
		'UG325' => __( 'Kole', 'learning-management-system' ),
		'UG306' => __( 'Kotido', 'learning-management-system' ),
		'UG208' => __( 'Kumi', 'learning-management-system' ),
		'UG333' => __( 'Kwania', 'learning-management-system' ),
		'UG228' => __( 'Kween', 'learning-management-system' ),
		'UG123' => __( 'Kyankwanzi', 'learning-management-system' ),
		'UG422' => __( 'Kyegegwa', 'learning-management-system' ),
		'UG415' => __( 'Kyenjojo', 'learning-management-system' ),
		'UG125' => __( 'Kyotera', 'learning-management-system' ),
		'UG326' => __( 'Lamwo', 'learning-management-system' ),
		'UG307' => __( 'Lira', 'learning-management-system' ),
		'UG229' => __( 'Luuka', 'learning-management-system' ),
		'UG104' => __( 'Luwero', 'learning-management-system' ),
		'UG124' => __( 'Lwengo', 'learning-management-system' ),
		'UG114' => __( 'Lyantonde', 'learning-management-system' ),
		'UG223' => __( 'Manafwa', 'learning-management-system' ),
		'UG320' => __( 'Maracha', 'learning-management-system' ),
		'UG105' => __( 'Masaka', 'learning-management-system' ),
		'UG409' => __( 'Masindi', 'learning-management-system' ),
		'UG214' => __( 'Mayuge', 'learning-management-system' ),
		'UG209' => __( 'Mbale', 'learning-management-system' ),
		'UG410' => __( 'Mbarara', 'learning-management-system' ),
		'UG423' => __( 'Mitooma', 'learning-management-system' ),
		'UG115' => __( 'Mityana', 'learning-management-system' ),
		'UG308' => __( 'Moroto', 'learning-management-system' ),
		'UG309' => __( 'Moyo', 'learning-management-system' ),
		'UG106' => __( 'Mpigi', 'learning-management-system' ),
		'UG107' => __( 'Mubende', 'learning-management-system' ),
		'UG108' => __( 'Mukono', 'learning-management-system' ),
		'UG334' => __( 'Nabilatuk', 'learning-management-system' ),
		'UG311' => __( 'Nakapiripirit', 'learning-management-system' ),
		'UG116' => __( 'Nakaseke', 'learning-management-system' ),
		'UG109' => __( 'Nakasongola', 'learning-management-system' ),
		'UG230' => __( 'Namayingo', 'learning-management-system' ),
		'UG234' => __( 'Namisindwa', 'learning-management-system' ),
		'UG224' => __( 'Namutumba', 'learning-management-system' ),
		'UG327' => __( 'Napak', 'learning-management-system' ),
		'UG310' => __( 'Nebbi', 'learning-management-system' ),
		'UG231' => __( 'Ngora', 'learning-management-system' ),
		'UG424' => __( 'Ntoroko', 'learning-management-system' ),
		'UG411' => __( 'Ntungamo', 'learning-management-system' ),
		'UG328' => __( 'Nwoya', 'learning-management-system' ),
		'UG331' => __( 'Omoro', 'learning-management-system' ),
		'UG329' => __( 'Otuke', 'learning-management-system' ),
		'UG321' => __( 'Oyam', 'learning-management-system' ),
		'UG312' => __( 'Pader', 'learning-management-system' ),
		'UG332' => __( 'Pakwach', 'learning-management-system' ),
		'UG210' => __( 'Pallisa', 'learning-management-system' ),
		'UG110' => __( 'Rakai', 'learning-management-system' ),
		'UG429' => __( 'Rubanda', 'learning-management-system' ),
		'UG425' => __( 'Rubirizi', 'learning-management-system' ),
		'UG431' => __( 'Rukiga', 'learning-management-system' ),
		'UG412' => __( 'Rukungiri', 'learning-management-system' ),
		'UG111' => __( 'Sembabule', 'learning-management-system' ),
		'UG232' => __( 'Serere', 'learning-management-system' ),
		'UG426' => __( 'Sheema', 'learning-management-system' ),
		'UG215' => __( 'Sironko', 'learning-management-system' ),
		'UG211' => __( 'Soroti', 'learning-management-system' ),
		'UG212' => __( 'Tororo', 'learning-management-system' ),
		'UG113' => __( 'Wakiso', 'learning-management-system' ),
		'UG313' => __( 'Yumbe', 'learning-management-system' ),
		'UG330' => __( 'Zombo', 'learning-management-system' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'learning-management-system' ),
		'84' => __( 'Howland Island', 'learning-management-system' ),
		'86' => __( 'Jarvis Island', 'learning-management-system' ),
		'67' => __( 'Johnston Atoll', 'learning-management-system' ),
		'89' => __( 'Kingman Reef', 'learning-management-system' ),
		'71' => __( 'Midway Atoll', 'learning-management-system' ),
		'76' => __( 'Navassa Island', 'learning-management-system' ),
		'95' => __( 'Palmyra Atoll', 'learning-management-system' ),
		'79' => __( 'Wake Island', 'learning-management-system' ),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'learning-management-system' ),
		'AK' => __( 'Alaska', 'learning-management-system' ),
		'AZ' => __( 'Arizona', 'learning-management-system' ),
		'AR' => __( 'Arkansas', 'learning-management-system' ),
		'CA' => __( 'California', 'learning-management-system' ),
		'CO' => __( 'Colorado', 'learning-management-system' ),
		'CT' => __( 'Connecticut', 'learning-management-system' ),
		'DE' => __( 'Delaware', 'learning-management-system' ),
		'DC' => __( 'District Of Columbia', 'learning-management-system' ),
		'FL' => __( 'Florida', 'learning-management-system' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'learning-management-system' ),
		'HI' => __( 'Hawaii', 'learning-management-system' ),
		'ID' => __( 'Idaho', 'learning-management-system' ),
		'IL' => __( 'Illinois', 'learning-management-system' ),
		'IN' => __( 'Indiana', 'learning-management-system' ),
		'IA' => __( 'Iowa', 'learning-management-system' ),
		'KS' => __( 'Kansas', 'learning-management-system' ),
		'KY' => __( 'Kentucky', 'learning-management-system' ),
		'LA' => __( 'Louisiana', 'learning-management-system' ),
		'ME' => __( 'Maine', 'learning-management-system' ),
		'MD' => __( 'Maryland', 'learning-management-system' ),
		'MA' => __( 'Massachusetts', 'learning-management-system' ),
		'MI' => __( 'Michigan', 'learning-management-system' ),
		'MN' => __( 'Minnesota', 'learning-management-system' ),
		'MS' => __( 'Mississippi', 'learning-management-system' ),
		'MO' => __( 'Missouri', 'learning-management-system' ),
		'MT' => __( 'Montana', 'learning-management-system' ),
		'NE' => __( 'Nebraska', 'learning-management-system' ),
		'NV' => __( 'Nevada', 'learning-management-system' ),
		'NH' => __( 'New Hampshire', 'learning-management-system' ),
		'NJ' => __( 'New Jersey', 'learning-management-system' ),
		'NM' => __( 'New Mexico', 'learning-management-system' ),
		'NY' => __( 'New York', 'learning-management-system' ),
		'NC' => __( 'North Carolina', 'learning-management-system' ),
		'ND' => __( 'North Dakota', 'learning-management-system' ),
		'OH' => __( 'Ohio', 'learning-management-system' ),
		'OK' => __( 'Oklahoma', 'learning-management-system' ),
		'OR' => __( 'Oregon', 'learning-management-system' ),
		'PA' => __( 'Pennsylvania', 'learning-management-system' ),
		'RI' => __( 'Rhode Island', 'learning-management-system' ),
		'SC' => __( 'South Carolina', 'learning-management-system' ),
		'SD' => __( 'South Dakota', 'learning-management-system' ),
		'TN' => __( 'Tennessee', 'learning-management-system' ),
		'TX' => __( 'Texas', 'learning-management-system' ),
		'UT' => __( 'Utah', 'learning-management-system' ),
		'VT' => __( 'Vermont', 'learning-management-system' ),
		'VA' => __( 'Virginia', 'learning-management-system' ),
		'WA' => __( 'Washington', 'learning-management-system' ),
		'WV' => __( 'West Virginia', 'learning-management-system' ),
		'WI' => __( 'Wisconsin', 'learning-management-system' ),
		'WY' => __( 'Wyoming', 'learning-management-system' ),
		'AA' => __( 'Armed Forces (AA)', 'learning-management-system' ),
		'AE' => __( 'Armed Forces (AE)', 'learning-management-system' ),
		'AP' => __( 'Armed Forces (AP)', 'learning-management-system' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'learning-management-system' ),
		'FS'  => __( 'Free State', 'learning-management-system' ),
		'GP'  => __( 'Gauteng', 'learning-management-system' ),
		'KZN' => __( 'KwaZulu-Natal', 'learning-management-system' ),
		'LP'  => __( 'Limpopo', 'learning-management-system' ),
		'MP'  => __( 'Mpumalanga', 'learning-management-system' ),
		'NC'  => __( 'Northern Cape', 'learning-management-system' ),
		'NW'  => __( 'North West', 'learning-management-system' ),
		'WC'  => __( 'Western Cape', 'learning-management-system' ),
	),
	'VE' => array( // Venezuela states.
		'VE-A' => __( 'Capital', 'learning-management-system' ),
		'VE-B' => __( 'Anzoátegui', 'learning-management-system' ),
		'VE-C' => __( 'Apure', 'learning-management-system' ),
		'VE-D' => __( 'Aragua', 'learning-management-system' ),
		'VE-E' => __( 'Barinas', 'learning-management-system' ),
		'VE-F' => __( 'Bolívar', 'learning-management-system' ),
		'VE-G' => __( 'Carabobo', 'learning-management-system' ),
		'VE-H' => __( 'Cojedes', 'learning-management-system' ),
		'VE-I' => __( 'Falcón', 'learning-management-system' ),
		'VE-J' => __( 'Guárico', 'learning-management-system' ),
		'VE-K' => __( 'Lara', 'learning-management-system' ),
		'VE-L' => __( 'Mérida', 'learning-management-system' ),
		'VE-M' => __( 'Miranda', 'learning-management-system' ),
		'VE-N' => __( 'Monagas', 'learning-management-system' ),
		'VE-O' => __( 'Nueva Esparta', 'learning-management-system' ),
		'VE-P' => __( 'Portuguesa', 'learning-management-system' ),
		'VE-R' => __( 'Sucre', 'learning-management-system' ),
		'VE-S' => __( 'Táchira', 'learning-management-system' ),
		'VE-T' => __( 'Trujillo', 'learning-management-system' ),
		'VE-U' => __( 'Yaracuy', 'learning-management-system' ),
		'VE-V' => __( 'Zulia', 'learning-management-system' ),
		'VE-W' => __( 'Federal Dependencies', 'learning-management-system' ),
		'VE-X' => __( 'La Guaira (Vargas)', 'learning-management-system' ),
		'VE-Y' => __( 'Delta Amacuro', 'learning-management-system' ),
		'VE-Z' => __( 'Amazonas', 'learning-management-system' ),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'learning-management-system' ),
		'ZM-02' => __( 'Central', 'learning-management-system' ),
		'ZM-03' => __( 'Eastern', 'learning-management-system' ),
		'ZM-04' => __( 'Luapula', 'learning-management-system' ),
		'ZM-05' => __( 'Northern', 'learning-management-system' ),
		'ZM-06' => __( 'North-Western', 'learning-management-system' ),
		'ZM-07' => __( 'Southern', 'learning-management-system' ),
		'ZM-08' => __( 'Copperbelt', 'learning-management-system' ),
		'ZM-09' => __( 'Lusaka', 'learning-management-system' ),
		'ZM-10' => __( 'Muchinga', 'learning-management-system' ),
	),
);
