<?php
/**
 * Check License Expiration Job.
 *
 * @package Masteriyo\Jobs
 */

namespace Masteriyo\Jobs;

use Masteriyo\Enums\LicenseStatus;
use Masteriyo\Pro\License;

/**
 * CheckLicenseExpirationJob class.
 *
 * @since 2.6.6
 */
class CheckLicenseExpirationJob {

	/**
	 * Name of the job.
	 *
	 * @since 2.6.6
	 */
	const NAME = 'masteriyo/job/check-license-expiration';

	/**
	 * Registers the job to run on WordPress option update.
	 *
	 * This method adds the appropriate action for the job to run
	 * when the "update_option_masteriyo_settings" action is triggered.
	 *
	 * @since 2.6.6
	 */
	public function register() {
		add_action( self::NAME, array( $this, 'process' ) );
	}

	/**
	 * Start the license expiration process.
	 *
	 * @since 2.6.6
	 */
	public function process() {
		$license     = new License();
		$license_key = $license->get_license_key();

		if ( ! masteriyo_pro_validate_license( $license_key ) ) {
			// Update the license status as inactive.

			$data = $license->get_activation_data();

			$data['activated']             = false;
			$data['license_key']['status'] = LicenseStatus::INACTIVE;

			$license->set_activation_data( $data );
		}
	}
}
