<?php
/**
 * Subscriptions class.
 *
 * @since 2.6.10
 *
 * @package Masteriyo\PostType
 */

namespace Masteriyo\PostType;

/**
 * Subscriptions class.
 */
class Subscription extends PostType {
	/**
	 * Post slug.
	 *
	 * @since 2.6.10
	 *
	 * @var string
	 */
	protected $slug = 'mto-subscription';

	/**
	 * Constructor.
	 *
	 * @since 2.6.10
	 */
	public function __construct() {
		$debug = masteriyo_is_post_type_debug_enabled();

		$this->labels = array(
			'name'                  => _x( 'Subscriptions', 'Subscription General Name', 'learning-management-system' ),
			'singular_name'         => _x( 'Subscription', 'Subscription Singular Name', 'learning-management-system' ),
			'menu_name'             => __( 'Subscriptions', 'learning-management-system' ),
			'name_admin_bar'        => __( 'Subscription', 'learning-management-system' ),
			'archives'              => __( 'Subscription Archives', 'learning-management-system' ),
			'attributes'            => __( 'Subscription Attributes', 'learning-management-system' ),
			'parent_item_colon'     => __( 'Parent Subscription:', 'learning-management-system' ),
			'all_items'             => __( 'All Subscriptions', 'learning-management-system' ),
			'add_new_item'          => __( 'Add New Item', 'learning-management-system' ),
			'add_new'               => __( 'Add New', 'learning-management-system' ),
			'new_item'              => __( 'New Subscription', 'learning-management-system' ),
			'edit_item'             => __( 'Edit Subscription', 'learning-management-system' ),
			'update_item'           => __( 'Update Subscription', 'learning-management-system' ),
			'view_item'             => __( 'View Subscription', 'learning-management-system' ),
			'view_items'            => __( 'View Subscriptions', 'learning-management-system' ),
			'search_items'          => __( 'Search Subscription', 'learning-management-system' ),
			'not_found'             => __( 'Not found', 'learning-management-system' ),
			'not_found_in_trash'    => __( 'Not found in Trash.', 'learning-management-system' ),
			'featured_image'        => __( 'Featured Image', 'learning-management-system' ),
			'set_featured_image'    => __( 'Set featured image', 'learning-management-system' ),
			'remove_featured_image' => __( 'Remove featured image', 'learning-management-system' ),
			'use_featured_image'    => __( 'Use as featured image', 'learning-management-system' ),
			'insert_into_item'      => __( 'Insert into subscription', 'learning-management-system' ),
			'uploaded_to_this_item' => __( 'Uploaded to this subscription', 'learning-management-system' ),
			'items_list'            => __( 'Subscriptions list', 'learning-management-system' ),
			'items_list_navigation' => __( 'Subscriptions list navigation', 'learning-management-system' ),
			'filter_items_list'     => __( 'Filter subscriptions list', 'learning-management-system' ),
		);

		$this->args = array(
			'label'               => __( 'Subscriptions', 'learning-management-system' ),
			'description'         => __( 'Subscriptions Description', 'learning-management-system' ),
			'labels'              => $this->labels,
			'supports'            => array( 'title', 'editor', 'author', 'custom-fields', 'post-formats' ),
			'taxonomies'          => array(),
			'hierarchical'        => true,
			'public'              => $debug,
			'menu_position'       => 5,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'show_in_rest'        => true,
			'has_archive'         => true,
			'map_meta_cap'        => true,
			'capability_type'     => array( 'subscription', 'subscriptions' ),
			'exclude_from_search' => false,
			'publicly_queryable'  => is_admin(),
			'can_export'          => true,
			'delete_with_user'    => true,
		);
	}
}
