<?php
/**
 * Plugin Name: Masteriyo PRO - LMS for WordPress
 * Plugin URI: https://masteriyo.com/wordpress-lms/
 * Description: A Complete WordPress LMS plugin to create and sell online courses in no time.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Version: 2.17.1
 * Requires at least: 6.5
 * Requires PHP: 7.2
 * Text Domain: learning-management-system
 * Domain Path: /i18n/languages
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

use Masteriyo\Masteriyo;
use Masteriyo\Pro\Addons;
use Masteriyo\Pro\PluginUpdater;

defined( 'ABSPATH' ) || exit;

// Deactivate free plugin if it is installed.
if ( in_array( 'learning-management-system/lms.php', get_option( 'active_plugins', array() ), true ) ) {
	add_action(
		'admin_notices',
		function() {
			printf(
				'<div class="notice notice-info is-dismissible"><p><strong>%s </strong>%s</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">%s</span></button></div>',
				esc_html( 'Masteriyo:' ),
				wp_kses_post( 'Masteriyo PRO doesn\'t require free version of the plugin. So, free version has now been deactivated', 'learning-management-system' ),
				esc_html__( 'Dismiss this notice.', 'learning-management-system' )
			);
		}
	);


	if ( function_exists( 'deactivate_plugins' ) && function_exists( 'wp_safe_redirect' ) ) {
		/**
		 * It deactivates the free version and redirects the user back to the current page to avoid any conflicts.
		 *
		 * @since 2.12.2
		 */
		deactivate_plugins( 'learning-management-system/lms.php' );
		wp_safe_redirect( $_SERVER['REQUEST_URI'] );
		exit;
	}
}

define( 'MASTERIYO_SLUG', 'learning-management-system' );
define( 'MASTERIYO_VERSION', '2.17.1' );
define( 'MASTERIYO_PLUGIN_FILE', __FILE__ );
define( 'MASTERIYO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_PLUGIN_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_ASSETS', dirname( __FILE__ ) . '/assets' );
define( 'MASTERIYO_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_LANGUAGES', dirname( __FILE__ ) . '/i18n/languages' );
define( 'MASTERIYO_PRO_MODULES_DIR', dirname( __FILE__ ) . '/modules' );
define( 'MASTERIYO_PRO_ADDONS_DIR', dirname( __FILE__ ) . '/addons' );
define( 'MASTERIYO_LOG_DIR', wp_upload_dir()['basedir'] . '/masteriyo/masteriyo-logs/' );
define( 'MASTERIYO_LOG_URL', wp_upload_dir()['baseurl'] . '/masteriyo/masteriyo-logs/' );
define( 'MASTERIYO_UPLOAD_DIR', 'masteriyo' );

/**
 * The API URL to check for updates.
 * This should be unique to this plugin and point to a remote server
 * running the Lemon Squeezy plugin.
 */
define( 'MASTERIYO_PRO_API_URL', 'https://masteriyo.com/wp-json/lsq/v1' );

if ( ! defined( 'MASTERIYO_PRO_ADDONS_DIR' ) ) {
	define( 'MASTERIYO_PRO_ADDONS_DIR', dirname( __FILE__ ) . '/addons' );
}

/**
 * Include the autoloader.
 */
require_once dirname( __FILE__ ) . '/vendor/autoload.php';

/**
 * Include action scheduler.
 *
 * @since 1.5.35
 */
require_once dirname( __FILE__ ) . '/vendor/woocommerce/action-scheduler/action-scheduler.php';

// Check whether assets are built or not.
if ( masteriyo_is_production() && ! file_exists( dirname( __FILE__ ) . '/assets/js/build/masteriyo-backend.js' ) ) {
	add_action(
		'admin_notices',
		function() {
			printf(
				'<div class="notice notice-error is-dismissible"><p><strong>%s </strong>%s</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">%s</span></button></div>',
				esc_html( 'Masteriyo:' ),
				wp_kses_post( 'Assets are need to be built. Run <code>yarn && yarn build</code> from the wp-content/plugins/learning-management-system-pro directory.', 'learning-management-system' ),
				esc_html__( 'Dismiss this notice.', 'learning-management-system' )
			);
		}
	);

	add_action(
		'admin_init',
		function() {
			deactivate_plugins( plugin_basename( MASTERIYO_PLUGIN_FILE ) );

			if ( isset( $_GET['activate'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
				// phpcs:ignore WordPress.Security.NonceVerification.Recommended
				unset( $_GET['activate'] );
			}
		},
		0
	);

	return;
}


// Check for the existence of autoloader file.
if ( ! file_exists( dirname( __FILE__ ) . '/vendor/autoload.php' ) ) {
	add_action(
		'admin_notices',
		function() {
			printf(
				'<div class="notice notice-error is-dismissible"><p><strong>%s </strong>%s</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">%s</span></button></div>',
				esc_html( 'Masteriyo:' ),
				wp_kses_post( 'Requires autoloader files to work properly. Run <code>composer update</code> from the wp-content/plugins/learning-management-system-pro directory.', 'learning-management-system' ),
				esc_html__( 'Dismiss this notice.', 'learning-management-system' )
			);
		}
	);

	add_action(
		'admin_init',
		function() {
			deactivate_plugins( plugin_basename( MASTERIYO_PLUGIN_FILE ) );

			if ( isset( $_GET['activate'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
				// phpcs:ignore WordPress.Security.NonceVerification.Recommended
				unset( $_GET['activate'] );
			}
		}
	);

	return;
}

if ( ! function_exists( 'masteriyo' ) ) {

	// Instantiate the updater class.
	new PluginUpdater(
		plugin_basename( MASTERIYO_PLUGIN_FILE ),
		plugin_basename( __DIR__ ),
		MASTERIYO_VERSION,
		MASTERIYO_PRO_API_URL
	);

	// Load all addons.
	( new Addons() )->load_all();

	/**
	 * Bootstrap the application.
	 */
	$GLOBALS['masteriyo'] = require_once dirname( __FILE__ ) . '/bootstrap/app.php';

	/**
	 * Return the service container.
	 *
	 * @since 1.0.0
	 *
	 * @param string $class Class name or alias.
	 * @return Masteriyo\Masteriyo
	 */
	function masteriyo( $class = 'app' ) {
		global $masteriyo;

		return empty( $class ) ? $masteriyo : $masteriyo->get( $class );
	}

	// Initialize pro module.
	$GLOBALS['masteriyo']->get( 'pro' )->init();

	// Initialize the application.
	$GLOBALS['masteriyo']->get( 'app' );

}
