<?php
/**
 * License class service provider.
 *
 * @since 2.5.0
 */

namespace Masteriyo\Pro\Providers;

defined( 'ABSPATH' ) || exit;

use League\Container\ServiceProvider\AbstractServiceProvider;
use Masteriyo\Pro\Controllers\LicenseControllers;
use Masteriyo\Pro\License;

class LicenseServiceProvider extends AbstractServiceProvider {
	/**
	 * The provided array is a way to let the container
	 * know that a service is provided by this service
	 * provider. Every service that is registered via
	 * this service provider must have an alias added
	 * to this array or it will be ignored
	 *
	 * @since 2.5.0
	 *
	 * @var array
	 */
	protected $provides = array(
		'license',
		'license.rest',
		LicenseControllers::class,
	);

	/**
	 * This is where the magic happens, within the method you can
	* access the container and register or retrieve anything
	* that you need to, but remember, every alias registered
	* within this method must be declared in the `$provides` array.
	*
	* @since 2.5.0
	*/
	public function register() {
		$this->getContainer()->add( 'license', License::class, true );
		$this->getContainer()->add( 'license.rest', LicenseControllers::class, true )
			->addArgument( 'license' );

		$this->getContainer()->add( LicenseControllers::class, LicenseControllers::class )->addArgument( 'license' );
	}
}
