![WordPress LMS](https://ps.w.org/learning-management-system/assets/banner-1544x500.png?rev=2599799)

# LMS for WordPress ![status](https://github.com/wpeverest/learning-management-system-pro/actions/workflows/deploy-to-staging.yml/badge.svg)

## Getting Started

You must ensure that you have installed each necessary before you can start using the Masteriyo.

### Prerequisites

- [Node](https://nodejs.org/it/download/current): Download and install v19.
- [NVM](https://github.com/nvm-sh/nvm): Although there are alternative ways to install Node, we advise utilizing NVM to stay on the same version as our development teams. You can make sure you're using the right version of Node by utilizing the .nvmrc file in our repository.
- [Yarn](https://classic.yarnpkg.com/lang/en/docs/install/#debian-stable): Our repository uses yarn to control project dependencies and execute several scripts needed for creating and testing projects.
- PHP 7.2+: Masteriyo current minimum PHP need is version 7.2. Additionally, it is required to execute Composer and different project-build scripts. For help troubleshooting PHP installation issues, see troubleshooting.
- [Composer](https://getcomposer.org/download/)We use Composer v1 to manage all of the dependencies for PHP packages and plugins using Composer. Note, composer v2 can work but we aren't sure.

### How to set up the development environment?

- Modify the `.env` file.

  ```env
    WORDPRESS_URL='http://masteriyo.test'
  ```

  `WORDPRESS_URL` should be the URL of the WordPress installation e.g. http://localhost/masteriyo for XAMPP setup.

- Add the following code inside the `wp-config.php` file located under the root WordPress directory.
  ```php
  define( 'SCRIPT_DEBUG', true );
  define( 'WP_DEBUG', true );
  define( 'WP_DEBUG_DISPLAY', false );
  define( 'WP_DEBUG_LOG', true );
  define( 'MASTERIYO_DEVELOPMENT', true ); // This need to be set for hot reloading in react.
  ```

## Commands

- `yarn start`: Start react development server with hot reloading.
- `yarn build`" Build the projects but don't build blocks.
- `yarn build:blocks`: Build blocks codebase.
- `yarn build && yarn build:blocks`: Build all the projects.
- `yarn release`: Create final release zip of the projects.
- `composer run makepot`: Create the pot file.
- `composer run phpcs`: Lint PHP files.
- `composer run phpcbf`: Fix PHP formatting errors.

## Project structure.

- `includes/PostType`: All the post types are here.
- `includes/Models`: All the models are here.
- `includes/Providers`: All the service providers are here.
- `includes/AjaxHandlers`: All the Ajax handlers are here.
- `includes/Repository`: All the model's repositories are here.
- `includes/RestApi`: All the REST API controllers are here.
- `includes/Compatibility`: Third party plugin compatibility like SEO and Cache are here.
- `includes/Jobs`: All the background related jobs are stored here.
- `addons`: Include all the addons.
- `database/migrations`: All the database migrations are stored here.
- `templates`: All the PHP templates are here.

### Important PHP libraries which have been used.

- [PHP Container](https://container.thephpleague.com/): Provides container and implement auto dependency injection.
- [JSON Machine](https://github.com/halaxa/json-machine): Allows to handle JSON files efficiently. Currently, used for courses import/export.
- [Action Scheduler](https://actionscheduler.org/): Allows to create background queue jobs. Currently, used for sending emails, triggering webhooks and other background-related tasks.
- [pelago/emogrifier](https://github.com/MyIntervals/emogrifier): Converts CSS styles into inline style attributes in your HTML code. Currently, used for styling email.

### How code is structured?

We have been heavily influenced by WooCommerce and Laravel. We have tried to implement our custom ORM in Active Record pattern.

1. Models: We have model classes like Course, Lesson, Quiz, etc. to reflect database entries.
2. Repository: All model classes have their repository to perform CRUD operations in the database.
3. Controllers: Each model has their controller for REST API operations.

### How to release the Free version?

We use [semantic](https://semver.org/) versioning.

- Create a branch for the release with the name `release/`<version>`.
  ```git
  git checkout -b release/<version>
  ```
- Bump the version in the following files. (Note: you can use `yarn bumpPath` to only bump the Patch version)

  - composer.json
  - package.json
  - lms.php
  - readme.txt
  - uninstall.php

- Rename `x.x.x` to the specific version which you are currently releasing.
- Add changelog to `readme.txt`.
- Run `yarn && yarn build && yarn build:blocks` to compile JS and SCSS assets.
- Run `composer run makepot` to generate the translation(POT) file.
- Run `yarn release` to create a release zip that is under the `release` directory.
- Test the release zip on a fresh website like [TasteWP](https://tastewp.com/).
- Create a commit like `[Free] Update to v<version>`.
  Push the changes.
- Create a PR on the free git repository and `Squash and Merge` the release PR to the `develop`.
- Now, create a release version from [here](https://github.com/Masteriyo/learning-management-system/releases), add a changelog and upload the released zip.
- Announce the new release in the `Masteriyo->General` channel.

### How to release the Pro version?

Before releasing the Pro version, you need to make sure, you have set up your Pro repository correctly.
Run `git remote -v` and make sure you have two remotes.

```git
origin          git@github.com:wpeverest/learning-management-system-pro.git (fetch)
origin          git@github.com:wpeverest/learning-management-system-pro.git (push)
upstream        git@github.com:Masteriyo/learning-management-system.git (fetch)
upstream        git@github.com:Masteriyo/learning-management-system.git (push)
```

As you can see, `origin` points to the PRO repository whereas `upstream` points to the Free repository.
Now, if up to now all is good, we can proceed to release the pro version.

- Run `git pull upstream develop` to pull changes from the Free repository.
- Run `git merge upstream/develop develop` to pull changes from Free's develop branch to Pro's develop branch.
- Resolve merge conflicts and merge.

- Create a branch for the release with the name `release-pro/`<version>`.
  ```git
  git checkout -b release/<version>
  ```
- Bump the version in the following files. (Note: you can use `yarn bumpPath` to only bump the Patch version)

  - composer.json
  - package.json
  - lms.php
  - readme.txt
  - uninstall.php

- Rename `x.x.x` to the specific version which you are currently releasing. (Note: Pro version always starts with `2.x.x`
- Add changelog to `changelog.txt`.
- Run `yarn && yarn build && yarn build:blocks` to compile JS and SCSS assets.
- Run `composer run makepot` to generate the translation(POT) file.
- Run `yarn release` to create a release zip that is under the `release` directory.
- Test the release zip on a fresh website like [TasteWP](https://tastewp.com/).
- Create a commit like `[Update] Update to v<version>`.
  Push the changes.
- Create a PR on the pro git repository and `Squash and Merge` the release PR to the `develop`.
- Now, create a release version from [here](https://github.com/wpeverest/learning-management-system-pro/releases), add a changelog and upload the released zip.
- Announce the new release in the `Masteriyo->General` channel.
- Now, upload the released zip to the [Lemon Squeezy](https://github.com/wpeverest/learning-management-system-pro/blob/develop/lemon-squeezy.md) according to this [doc](https://github.com/wpeverest/learning-management-system-pro/blob/develop/lemon-squeezy.md).
