<?php

/**
 * "Add to Cart" button.
 *
 * @version 1.0.0
 */

use Masteriyo\Addons\CourseBundle\Models\CourseBundle;
use Masteriyo\Enums\CourseProgressStatus;
use Masteriyo\Notice;

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires after rendering course bundle buy button.
 *
 * @param CourseBundle $course_bundle Course object.
 */
do_action( 'masteriyo_before_course_bundle_buy_button', $course_bundle );

/**
 * Filter the additional attributes for the enroll button.
 *
 * @since 2.15.0
 */
$additional_attributes        = apply_filters( 'masteriyo_add_to_cart_button_attributes_bundle', array(), $course_bundle );
$additional_attributes_string = '';
foreach ( $additional_attributes as $key => $value ) {
	$additional_attributes_string .= sprintf( ' %s="%s"', esc_attr( $key ), esc_attr( $value ) );
}
?>

<?php if ( $user_has_bought_bundle ) : ?>
	<a
		href="
	<?php
	$url = esc_url( masteriyo_get_account_url() . '#/courses' );
	/**
	 * Filters the enroll button url for a course bundle.
	 *
	 * @since 2.15.0
	 *
	 * @param string $url Button url.
	 * @param Masteriyo\Addons\CourseBundle\Models\CourseBundle $course Course object.
	 */
	echo esc_html( apply_filters( 'masteriyo_course_bundle_buy_button_url', $url, $course_bundle ) );
	?>
	"
		class="<?php echo esc_attr( $class ); ?> "
		data-course-id="<?php echo esc_attr( $course_bundle->get_id() ); ?>"
		<?php echo esc_attr( $additional_attributes_string ); ?>
		>

		<?php
		$text = __( 'Explore', 'learning-management-system' );
		/**
		 * Filters the "Explore" button text for a course.
		 *
		 * @since 2.15.0
		 *
		 * @param string $text Button text.
		 * @param Masteriyo\Addons\CourseBundle\Models\CourseBundle $course Course object.
		 */
		echo esc_html( apply_filters( 'masteriyo_course_bundle_buy_button_text', $text, $course_bundle ) );
		?>
	</a>
<?php else : ?>
	<a href="<?php echo esc_url( $course_bundle->add_to_cart_url() ); ?>" class="<?php echo esc_attr( $class ); ?>">
		<?php echo wp_kses_post( $course_bundle->add_to_cart_text() ); ?>
	</a>
<?php endif; ?>
<?php

/**
 * Fires after rendering course bundle buy button.
 *
 * @param CourseBundle $course_bundle Course object.
 */
do_action( 'masteriyo_after_course_bundle_buy_button', $course_bundle );
