<?php

/**
 * The Template for displaying price and enroll button in single course bundle page
 *
 * This template can be overridden by copying it to yourtheme/masteriyo/single-course-bundle/price-and-enroll-button.php.
 *
 * HOWEVER, on occasion Masteriyo will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package Masteriyo\Templates
 * @version 2.12.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering price and enroll button section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_before_single_course_bundle_price_and_enroll_button' );
?>
<div class="masteriyo-time-btn">
	<div class="masteriyo-bundle-price">
		<span class="current-amount">
			<?php
			$price = $course_bundle->price_html();
			/**
			 * Filters the price for a course bundle in single course bundle page.
			 *
			 * @since 2.15.0
			 *
			 * @param string $price Button text.
			 * @param Masteriyo\Addons\CourseBundle\Models\CourseBundle $course Course object.
			 */
			echo wp_kses_post( apply_filters( 'masteriyo_single_course_bundle_buy_button_price', $price, $course_bundle ) );
			?>
			<?php
			//echo wp_kses_post( $course_bundle->price_html() );
			?>
		</span>
	</div>

	<?php
	/**
	 * Fires before rendering price and enroll button section in single course page.
	 *
	 * @since 2.15.0
	 */
	do_action( 'masteriyo_single_course_bundle_enroll_button', $course_bundle );
	?>

	<?php masteriyo_display_all_notices(); ?>
</div>
<?php

/**
 * Fires after rendering price and enroll button section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_after_single_course_bundle_price_and_enroll_button' );
