<?php

/**
 * The Template for displaying the countdown of remaining days for course access on a single course page.
 *
 * This template can be overridden by copying it to yourtheme/masteriyo/single-course/course-expiry-countdown.php.
 *
 * @package Masteriyo\Templates
 * @version 2.7.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering the countdown section in a single course page.
 *
 * @since 2.7.0
 */
do_action( 'masteriyo_before_course_expiry_countdown' );

?>
<div class="masteriyo-course-expiry-countdown">
	<div class="masteriyo-course-expiry-countdown__progress">
		<div class="circular-bar" role="progressbar" aria-valuemin="0" aria-valuemax="<?php echo esc_attr( absint( $remaining_validity_duration ) ); ?>" style="--value: <?php echo esc_attr( absint( $remaining_validity_duration ) ); ?>"></div>
		<div class="validity-countdown">
			<span class="validity-countdown--number">
				<?php echo esc_html( absint( $remaining_validity_duration ) ); ?>
			</span>
			<span class="validity-countdown--days">
				<?php esc_html_e( 'Day(s)', 'learning-management-system' ); ?>
			</span>
		</div>
	</div>

	<div class="masteriyo-course-expiry-countdown__content">
		<h3 class="masteriyo-course-expiry-countdown__heading">
			<?php esc_html_e( 'Time Until Enrollment Expires:', 'learning-management-system' ); ?>
		</h3>

		<p class="masteriyo-course-expiry-countdown__desc">
			<?php esc_html_e( 'Complete your course within the remaining time to maximize your learning experience.', 'learning-management-system' ); ?>
		</p>
	</div>
</div>
<?php

/**
 * Fires after rendering the countdown section in a single course page.
 *
 * @since 2.7.0
 */
do_action( 'masteriyo_after_course_expiry_countdown' );
