<?php
/**
 * UserRegistrationAdvancedFields Admin.
 *
 * @class    UR_Form_Field_Timepicker
 * @version  1.0.0
 * @package  UserRegistrationAdvancedFields/Form
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * UR_Form_Field_Timepicker Class
 */
class UR_Form_Field_Timepicker extends UR_Form_Field {

	/**
	 * Instance of this class.
	 *
	 * @var object
	 */
	private static $_instance;

	/**
	 * Get Instance of this class.
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Hook in tabs.
	 */
	public function __construct() {

		$this->id = 'user_registration_timepicker';

		$this->form_id = 1;

		$this->registered_fields_config = array(

			'label' => __( 'Time Picker', 'user-registration-advanced-fields' ),

			'icon'  => 'ur-icon ur-icon-time-picker',
		);
		$this->field_defaults           = array(

			'default_label'      => __( 'Time Picker', 'user-registration-advanced-fields' ),

			'default_field_name' => 'timepicker_' . ur_get_random_number(),

		);

		add_filter( "{$this->id}_advance_class", array( $this, 'settings_override' ), 10, 1 );
	}

	public function settings_override( $file_path_override ) {
		$file_path_override['file_path'] = URAF_ABSPATH . 'includes' . UR_DS . 'form' . UR_DS . 'settings' . UR_DS . 'class-ur-setting-timepicker.php';
		return $file_path_override;
	}

	/**
	 * Get registered admin fields.
	 */
	public function get_registered_admin_fields() {

		return '<li id="' . $this->id . '_list "

				class="ur-registered-item draggable"

                data-field-id="' . $this->id . '"><span class="' . $this->registered_fields_config['icon'] . '"></span>' . $this->registered_fields_config['label'] . '</li>';
	}


	/**
	 * Validate Timepicker field.
	 *
	 * @param mixed $single_form_field Single form field.
	 * @param mixed $form_data Form Data.
	 * @param mixed $filter_hook Filter hook.
	 * @param int   $form_id Form id.
	 */
	public function validation( $single_form_field, $form_data, $filter_hook, $form_id ) {

		$field_label = $single_form_field->general_setting->field_name;
		// checks if the time is given in range.
		$time_range_pattern = '/^(\d{1,2}:\d{2}(?:\s?[APap][Mm])?)\s+to\s+(\d{1,2}:\d{2}(?:\s?[APap][Mm])?)$/';
		$time_pattern       = '/^(0[0-9]|1[0-9]|2[0-3]|(?:1[0-2]|0?[1-9])):[0-5][0-9](?: [ap]m)?$/i';
		$value              = $form_data->value;
		if ( preg_match( $time_range_pattern, $value ) ) {
			$value = $form_data->value;
		} elseif ( preg_match( $time_pattern, $value ) ) {
			$value = $form_data->value;
		} else {
			$value = strtotime( $form_data->value );
		}

		if ( ! empty( $form_data->value ) && empty( $value ) ) {
			$message = array(
				/* translators: %s - validation message */
				$field_label => sprintf( __( 'Please choose a valid time.', 'user-registration-advanced-fields' ) ),
				'individual' => true,
			);
			add_filter(
				$filter_hook,
				function ( $msg ) use ( $message, $form_data ) {
					$message = apply_filters( 'user_registration_modify_field_validation_response', $message, $form_data );
					return $message;
				}
			);
			return;
		}

		if ( ! empty( $value ) && strpos( $value, 'to' ) ) {
			list( $start_time, $end_time ) = preg_split( '/\bto\b/', $value, 2 );

			if ( trim( $start_time ) === trim( $end_time ) ) {
				$message = array(
					/* translators: %s - validation message */
					$field_label => sprintf( __( 'Please select time other than same time.', 'user-registration-advanced-fields' ) ),
					'individual' => true,
				);

				add_filter(
					$filter_hook,
					function ( $msg ) use ( $message, $form_data ) {
						$message = apply_filters( 'user_registration_modify_field_validation_response', $message, $form_data );
						return $message;
					}
				);

				return;
			}
		}
	}
}

return UR_Form_Field_Timepicker::get_instance();
