<?php
/**
 * Installation related functions and actions.
 *
 * @class    URFU_Install
 * @version  1.0.0
 * @package  UserRegistrationFileUpload/Classes
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URFU_Install Class.
 */
class URFU_Install {

	/**
	 * Hook in tabs.
	 */
	public static function init() {
		add_action( 'init', array( __CLASS__, 'check_version' ), 5 );
		add_action( 'admin_init', array( __CLASS__, 'install_actions' ) );
		add_filter( 'plugin_action_links_' . URFU_PLUGIN_BASENAME, array( __CLASS__, 'plugin_action_links' ) );

	}

	/**
	 * Check UserRegistration version and run the updater is required.
	 *
	 * This check is done on all requests and runs if the versions do not match.
	 */
	public static function check_version() {
		if ( ! defined( 'IFRAME_REQUEST' ) && get_option( 'user_registration_file_upload' ) !== URFU()->version ) {
			self::install();
			do_action( 'user_registration_file_upload_updated' );
		}
	}

	/**
	 * Install actions when a update button is clicked within the admin area.
	 *
	 * This function is hooked into admin_init to affect admin only.
	 */
	public static function install_actions() {

	}

	/**
	 * Install UR.
	 */
	public static function install() {
		global $wpdb;

		if ( ! is_blog_installed() ) {
			return;
		}

		if ( ! defined( 'URFU_INSTALLING' ) ) {
			define( 'URFU_INSTALLING', true );
		}

		self::update_ur_version();
		self::create_options();

		// Trigger action.
		do_action( 'user_registration_file_upload_installed' );

		set_transient( '_urfu_activation_redirect', 1, 30 );

	}

	/**
	 * Default options.
	 *
	 * Sets up the default options used on the settings page.
	 */
	private static function create_options() {
		// Include settings so that we can run through defaults.
		$settings_advance = urfu_file_upload_settings();

		$settings = $settings_advance;

		foreach ( $settings as $setting ) {

			if ( isset( $setting['default'] ) && isset( $setting['id'] ) ) {
				$autoload = isset( $setting['autoload'] ) ? (bool) $setting['autoload'] : true;
				add_option( $setting['id'], $setting['default'], '', ( $autoload ? 'yes' : 'no' ) );
			}
		}

	}

	/**
	 * Update UR version to current.
	 */
	private static function update_ur_version() {
		delete_option( 'user_registration_file_upload' );
		add_option( 'user_registration_file_upload', URFU()->version );
	}

	/**
	 * Display action links in the Plugins list table.
	 *
	 * @param  array $actions
	 *
	 * @return array
	 */
	public static function plugin_action_links( $actions ) {

		$message = urfu_is_compatible();
		if ( 'YES' !== $message ) {

			return $actions;
		}
		$new_actions = array(
			'settings' => '<a href="' . admin_url( 'admin.php?page=user-registration-settings&tab=file_upload' ) . '" title="' . esc_attr( __( 'View User Registration Settings', 'user-registration-file-upload' ) ) . '">' . __( 'Settings', 'user-registration-file-upload' ) . '</a>',
		);

		return array_merge( $new_actions, $actions );
	}


}

URFU_Install::init();
