<?php
/**
 * User_Registration_Profile_Connect setup
 *
 * @package User_Registration_Profile_Connect
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Main User_Registration_Profile_Connect Class.
 *
 * @class User_Registration_Profile_Connect
 */
final class User_Registration_Profile_Connect {

	/**
	 * Plugin version.
	 *
	 * @var string
	 */
	const VERSION = '1.1.0';

	/**
	 * Instance of this class.
	 *
	 * @var object
	 */
	protected static $instance = null;

	/**
	 * Initialize the plugin.
	 */
	private function __construct() {
		// Load plugin text domain.
		add_action( 'init', array( $this, 'load_plugin_textdomain' ) );

		// Checks if user registration is installed
		$ur_pro_plugins_path = WP_PLUGIN_DIR . URPCONNECT_DS . 'user-registration-pro' . URPCONNECT_DS . 'user-registration.php';

		if ( file_exists( $ur_pro_plugins_path ) ) {

			$ur_pro_plugin_file_path = 'user-registration-pro/user-registration.php';
			include_once ABSPATH . 'wp-admin/includes/plugin.php';

			if ( is_plugin_active( $ur_pro_plugin_file_path ) ) {
				if ( defined( 'UR_VERSION' ) && version_compare( UR_VERSION, '4.0.0', '>=' ) ) {
					$this->includes();
					add_action( 'admin_init', array( $this, 'plugin_updater' ) );
				} else {
					add_action( 'admin_notices', array( $this, 'user_registration_missing_notice' ) );
				}
			} else {
				add_action( 'admin_notices', array( $this, 'user_registration_missing_notice' ) );
			}
		} else {
			add_action( 'admin_notices', array( $this, 'user_registration_missing_notice' ) );

		}
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_styles' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
	}

	/**
	 * Register Admin Styles
	 */
	public function admin_styles() {
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';

		wp_register_style( 'user-registration-profile-connect-admin-style', plugins_url( '/assets/css/user-registration-profile-connect-admin-style.css', UR_PROFILE_CONNECT_PLUGIN_FILE ), array(), self::VERSION );
		if ( 'user-registration-membership_page_user-registration-settings' === $screen_id ) {
			wp_enqueue_style( 'user-registration-profile-connect-admin-style' );
		}
	}

	/**
	 * Register Admin Scripts
	 */
	public function admin_scripts() {
		$suffix    = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';

		wp_register_script( 'urpc-admin-script', plugins_url( '/assets/js/user-registration-profile-connect-script' . $suffix . '.js', UR_PROFILE_CONNECT_PLUGIN_FILE ), array(), self::VERSION );

		if ( 'user-registration-membership_page_user-registration-settings' === $screen_id ) {
			wp_enqueue_script( 'urpc-admin-script' );
			wp_localize_script(
				'urpc-admin-script',
				'user_registration_profile_connect_params',
				array(
					'ajax_url'                      => admin_url( 'admin-ajax.php' ),
					'user_registration_profile_connect_form_field_mapping' => wp_create_nonce( 'user_registration_profile_connect_form_field_mapping_nonce' ),
					'ur_profile_connnect_db_tables' => user_registration_get_all_db_tables(),
				)
			);
		}
	}



	/**
	 * Return an instance of this class.
	 *
	 * @return object A single instance of this class.
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Load Localisation files.
	 *
	 * Note: the first-loaded translation file overrides any following ones if the same translation is present.
	 *
	 * Locales found in:
	 *      - WP_LANG_DIR/user-registration-profile-connect/user-registration-profile-connect-LOCALE.mo
	 *      - WP_LANG_DIR/plugins/user-registration-profile-connect-LOCALE.mo
	 */
	public function load_plugin_textdomain() {
		$locale = apply_filters( 'plugin_locale', get_locale(), 'user-registration-profile-connect' );

		load_textdomain( 'user-registration-profile-connect', WP_LANG_DIR . '/user-registration-profile-connect/user-registration-profile-connect-' . $locale . '.mo' );
		load_plugin_textdomain( 'user-registration-profile-connect', false, plugin_basename( dirname( UR_PROFILE_CONNECT_PLUGIN_FILE ) ) . '/languages' );
	}


	/**
	 * Plugin Updater.
	 */
	public function plugin_updater() {
		global $pagenow;
		if ( 'update-core.php' === $pagenow && ( isset( $_GET['force-check'] ) ) && ( '1' === $_GET['force-check'] ) ) {
			delete_transient( 'user_registration_pro_get_latest_version_update' );
		}

		if ( function_exists( 'ur_addon_updater' ) ) {
			if ( is_plugin_active( 'user-registration-pro/user-registration.php' ) ) {

				if ( version_compare( UR()->version, '4.1.4', '=' ) ) {
					$addon_update = get_transient( 'user_registration_pro_get_latest_version_update' );

					if ( false === $addon_update ) {
						delete_site_transient( 'update_plugins' );
						ur_addon_updater( UR_PLUGIN_FILE, 167196, UR()->version );
						set_transient( 'user_registration_pro_get_latest_version_update', true, 12 * HOUR_IN_SECONDS );
					}
				}
			}
		}
	}

	/**
	 * Includes.
	 */
	private function includes() {
		if ( is_admin() && current_user_can( 'promote_users' ) ) {
			include_once __DIR__ . '/class-user-registration-profile-connect-process.php';
		}
	}

	/**
	 * User Registration fallback notice.
	 */
	public function user_registration_missing_notice() {
		/* translators: %s: user-registration plugin link */
		echo '<div class="error notice is-dismissible"><p>' . sprintf( esc_html__( 'User Registration Profile Connect requires %s  version 4.0.0 or above to work', 'user-registration-profile-connect' ), '<a href="https://wpuserregistration.com/" target="_blank">' . esc_html__( 'User Registration Pro', 'user-registration-profile-connect' ) . '</a>' ) . '</p></div>';
	}
}
