<?php
/**
 * User_Registration_Settings_Profile_Connect
 *
 * @package User_Registration_Profile_Connect/Settings
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;


if ( ! class_exists( 'User_Registration_Settings_Profile_Connect ' ) ) :

	/**
	 * User_Registration_Settings_Profile_Connect Class
	 */
	class User_Registration_Settings_Profile_Connect extends UR_Settings_Page {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id    = 'profile_connect';
			$this->label = __( 'Profile Connect', 'user-registration-profile-connect' );
			add_filter( 'user_registration_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
			add_action( 'user_registration_sections_' . $this->id, array( $this, 'output_sections' ) );
			add_action( 'user_registration_settings_' . $this->id, array( $this, 'output' ) );
			add_filter( 'user_registration_admin_after_global_settings', array( $this, 'profile_connect_mapping_settings' ), 10,2  );
			add_action( 'user_registration_settings_save_' . $this->id, array( $this, 'save' ) );
			add_filter( 'show_user_registration_setting_message', array( $this, 'user_registration_setting_message_show' ) );
		}

		/**
		 * Show message option.
		 */
		public function user_registration_setting_message_show() {
			return true;
		}

		/**
		 * Output the settings
		 */
		public function output() {
			$settings = apply_filters( 'user_registration_' . $this->id .'_settings', $this->user_registration_profile_connect_settings() );
			UR_Admin_Settings::output_fields( $settings );
		}

		/**
		 * Append profile connect settings
		 */
		public function profile_connect_mapping_settings( $settings, $options) {

			if( isset($options['sections']['user_registration_profile_connect_settings'])) {
				$settings .= '<div class="user_registration_profile_connect_external_field_mapping_wrapper">';
				$settings .= $this->display_form_field_lists(  get_option( 'user_registration_profile_connect_settings_form', 0 ) );
				$settings .= '</div>';
			}
			return $settings;
		}

		/**
		 * Save settings
		 */
		public function save() {
			if ( empty( $_REQUEST['_wpnonce'] ) || ! wp_verify_nonce( $_REQUEST['_wpnonce'], 'user-registration-settings' ) ) {
				die( __( 'Action failed. Please refresh the page and retry.', 'user-registration' ) );
			}

			$settings = apply_filters( 'user_registration_' . $this->id .'_settings', $this->user_registration_profile_connect_settings() );
			UR_Admin_Settings::save_fields( $settings );

			$mapped_data = array();
			if ( isset( $_POST[ 'ur_profile_connect_external_map_form_fields' ] ) ) {
				$mapped_field_data = array();
				$form_id = absint( $_POST['user_registration_profile_connect_settings_form'] );
				$ur_field_list = $_POST[ 'ur_profile_connect_external_map_form_fields' ];
				$external_field_list = $_POST[ 'user_registration_form_value' ];
				$i = 0;
				foreach ($ur_field_list as $key => $ur_field) {
					$mapped_field_data[$i]['ur_field'] = $ur_field;
					$mapped_field_data[$i]['external_field'] = $external_field_list[$key];
					$i++;
				}
				$mapped_data['mapped_fields'] = $mapped_field_data;
			}
			if(!empty($mapped_data)){
				update_post_meta( $form_id, 'user_registration_profile_connect_external_fields_mapping', $mapped_data );
			}
		}

		/**
		 * To display form field list
		 */
		public function display_form_field_lists( $form_id ) {

			$get_all_fields       = user_registration_pro_get_conditional_fields_by_form_id( $form_id, '' );
			$external_fields_mapped = $this->get_external_field_mapping_list( $form_id, $get_all_fields );

			if ( $external_fields_mapped ) {
				return $external_fields_mapped;
			} else {
				$output  = '<div class="user-registration-card ur-mt-4 ur-border-0">';
				$output .= '<div class="user-registration-card__body pt-0 pb-0">';

				$output  .= '<div class="ur-profile-connect-fields-mapping-container">';
				$output .= '<div class="ur-profile-connect-external-fields-mapping-container">';

				$output .= '<div class="ur-profile-connect-field-mapping-wrap" >';
				$output .= '<ul class="ur-profile-connect-field-mapping-box" data-last-key="1">';

				$data_key = 1;
				$output .= '<li class="ur-profile-connect-mapping-header">';
				$output .= '<label>';
				$output .= esc_html__( 'External Field Keys', 'user-registration-profile-connect' );
				$output .= '</label>';
				$output .= '<label>';
				$output .= esc_html__( 'Form Fields', 'user-registration-profile-connect' );
				$output .= '</label>';
				$output .= '</li>';
				$output .= '<li class="ur-profile-connect-external-field-map-group" data-key="' . $data_key . '">';
				$output .= '<div class="ur-profile-connect-external-field-map-form-group">';
				$output .= '<input name="user_registration_form_value[' . $data_key . ']" class="ur_pro_external_field_name" placeholder="Enter Field Key" type="text" />';
				$output .= '</div>';
				$output .= '<div class="ur-profile-connect-operator"> <i class="dashicons dashicons-arrow-right-alt"></i> </div>';
				$output .= '<div class="ur-profile-connect-value">';
				$output .= '<select class="ur-profile-connect-fields ur-profile-connect-field-map-select" name="ur_profile_connect_external_map_form_fields[' . $data_key . ']">';
				$output .= '<option value="">' . esc_html__( '-- Select Form Field --', 'user-registration' ) . '</option>';

				foreach ( $get_all_fields as $ind_field_key => $ind_field_value ) {
					$output .= '<option value="' . esc_attr__( $ind_field_key, 'user-registration' ) . '" data-type="' . esc_attr__( $ind_field_value['field_key'], 'user-registration' ) . '"> ' . $ind_field_value['label'] . ' </option>';
				}
				$output .= '</select></div>';
				$output .= '<div class="ur-profile-connect-mapping-action">';
				$output .= '<span class="add">';
				$output .= '<i class="dashicons dashicons-plus"></i>';
				$output .= '</span>';
				$output .= '<span class="remove">';
				$output .= '<i class="dashicons dashicons-minus"></i>';
				$output .= '</span>';
				$output .= '</div>';
				$output .= '</li>';
				$output .= '</ul>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				return $output;
			}
		}

		/**
		 * Fetch Already mapped external fields.
		 *
		 * @param int   $form_id Form_id.
		 * @param array $get_all_fields All fields.
		 */
		public function get_external_field_mapping_list( $form_id, $get_all_fields ) {
			$mapped_fields = maybe_unserialize( get_post_meta( $form_id, 'user_registration_profile_connect_external_fields_mapping', true ) );

			if ( ! empty( $mapped_fields ) ) {
				$output  = '<div class="user-registration-card ur-mt-4 ur-border-0">';
				$output .= '<div class="user-registration-card__body pt-0 pb-0">';
				$output .= '<div class="ur-profile-connect-fields-mapping-container">';
				$output .= '<div class="ur-profile-connect-external-fields-mapping-container">';
				$output .= '<div class="ur-profile-connect-field-mapping-wrap" >';

					if ( isset( $mapped_fields['mapped_fields'] ) && isset( $mapped_fields['mapped_fields'] ) ) {

						$data_key = 1;

						$output .= '<ul class="ur-profile-connect-field-mapping-box" data-last-key="' . count( $mapped_fields['mapped_fields'] ) . '">';
						$output .= '<li class="ur-profile-connect-mapping-header">';
						$output .= '<label>';
						$output .= esc_html__( 'External Field Keys', 'user-registration-profile-connect' );
						$output .= '</label>';
						$output .= '<label>';
						$output .= esc_html__( 'Form Fields', 'user-registration-profile-connect' );
						$output .= '</label>';
						$output .= '</li>';
						foreach ($mapped_fields['mapped_fields'] as $key => $mapping_row ) {
							$output .= '<li class="ur-profile-connect-external-field-map-group" data-key="' . $data_key . '">';
							$output .= '<div class="ur-profile-connect-external-field-map-form-group">';

							$output .= '<input name="user_registration_form_value[' . $data_key . ']" value="' . esc_attr( $mapping_row['external_field'] ) . '" class="ur_pro_external_field_name" type="text" placeholder="Enter Field Key" />';
							$output .= '</div>';
							$output .= '<div class="ur-profile-connect-operator"> <i class="dashicons dashicons-arrow-right-alt"></i> </div>';
							$output .= '<div class="ur-profile-connect-value">';
							$output .= '<select class="ur-profile-connect-fields ur-profile-connect-field-map-select" name="ur_profile_connect_external_map_form_fields[' . $data_key . ']">';
							$output .= '<option value="">' . esc_html__( '-- Select Form Fields --', 'user-registration' ) . '</option>';

							foreach ( $get_all_fields as $ind_field_key => $ind_field_value ) {
								$selectedField = $mapping_row['ur_field'] == $ind_field_key ? 'selected="selected"' : '';
								$output .= '<option value="' . esc_attr__( $ind_field_key, 'user-registration' ) . '" data-type="' . esc_attr__( $ind_field_value['field_key'], 'user-registration' ) . '" ' . $selectedField . '> ' . $ind_field_value['label'] . ' </option>';
							}
							$output .= '</select></div>';
							$output .= '<div class="ur-profile-connect-mapping-action">';
							$output .= '<span class="add">';
							$output .= '<i class="dashicons dashicons-plus"></i>';
							$output .= '</span>';
							$output .= '<span class="remove">';
							$output .= '<i class="dashicons dashicons-minus"></i>';
							$output .= '</span>';
							$output .= '</div></li>';
							$data_key++;
						}
						$output .= '</ul>';
					}
					$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				return $output;
			}
		}

		/**
 * User Registration WooCoomerce Account Details Settings
 *
 * @return array
 */
public function user_registration_profile_connect_settings() {

	$forms    = ur_get_all_user_registration_form();
	$forms[0] = __( 'None', 'user-registration-profile-connect' );
	ksort( $forms );

	return apply_filters(
		'user_registration_profile_connect_settings',
		array(
			'title' => __( '', 'user-registration-profile-connect' ),
			'sections' => array(
				'user_registration_profile_connect_settings' => array(
					'title' => esc_html__( 'Map External Plugin Fields', 'user-registration-profile-connect' ),
					'type'  => 'card',
					'desc'  => '',
					'settings' => array(
						array(
							'title'    => __( 'Select Registration Form', 'user-registration-profile-connect' ),
							'desc'     => __( 'Choose registration form to map external plugins fields.', 'user-registration-profile-connect' ),
							'id'       => 'user_registration_profile_connect_settings_form',
							'default'  => 'None',
							'type'     => 'select',
							'class'    => 'ur-enhanced-select',
							'css'      => 'min-width: 350px;',
							'desc_tip' => true,
							'options'  => $forms,
						),
						array(
							'title'    => __( 'Select table from where you want to fetch data of selected fields.', 'user-registration-profile-connect' ),
							'desc'     => __( 'Select table from where you want to fetch data of selected fields.', 'user-registration-profile-connect' ),
							'id'       => 'user_registration_profile_connect_settings_table_selection',
							'default'  => 'usermeta',
							'type'     => 'select',
							'class'    => 'ur-enhanced-select',
							'css'      => 'min-width: 350px;',
							'row_class'=>  get_option('user_registration_profile_connect_settings_form',0) === 0 ? 'ur-default-hide' :'',
							'desc_tip' => true,
							'options'  =>  array(
											'usermeta_table' => "Usermeta Table",
											'external_table' => "External Table"
											)
						),
						array(
							'title'    => __( 'Table Name', 'user-registration-profile-connect' ),
							'desc'     => __( 'Table Name', 'user-registration-profile-connect' ),
							'id'       => 'user_registration_profile_connect_settings_db_table',
							'default'  => '',
							'type'     => 'select',
							'class'    => 'ur-enhanced-select',
							'css'      => 'min-width: 350px;',
							'row_class'=> get_option('user_registration_profile_connect_settings_table_selection','usermeta_table') !== 'external_table' ? 'ur-default-hide' :'',
							'desc_tip' => true,
							'options'  =>  user_registration_get_all_db_tables()
						),
						array(
							'title'    => __( 'Column for User ID', 'user-registration-profile-connect' ),
							'desc'     => __( 'Column for User ID', 'user-registration-profile-connect' ),
							'id'       => 'user_registration_profile_connect_settings_user_id_db_column',
							'default'  => '',
							'type'     => 'select',
							'class'    => 'ur-enhanced-select',
							'css'      => 'min-width: 350px;',
							'row_class'=> get_option('user_registration_profile_connect_settings_table_selection','usermeta_table') !== 'external_table' ? 'ur-default-hide' :'',
							'desc_tip' => true,
							'options'  => user_registration_get_columns_by_table( get_option('user_registration_profile_connect_settings_db_table',0) )
						),
						array(
							'title'    => __( 'Column for Field Key', 'user-registration-profile-connect' ),
							'desc'     => __( 'Column for Field Key', 'user-registration-profile-connect' ),
							'id'       => 'user_registration_profile_connect_settings_field_key_db_column',
							'default'  => '',
							'type'     => 'select',
							'class'    => 'ur-enhanced-select',
							'css'      => 'min-width: 350px;',
							'row_class'=> get_option('user_registration_profile_connect_settings_table_selection','usermeta_table') !== 'external_table' ? 'ur-default-hide' :'',
							'desc_tip' => true,
							'options'  => user_registration_get_columns_by_table( get_option('user_registration_profile_connect_settings_db_table',0) )
						),
						array(
							'title'    => __( 'Column for Field Value', 'user-registration-profile-connect' ),
							'desc'     => __( 'Column for Field Value', 'user-registration-profile-connect' ),
							'id'       => 'user_registration_profile_connect_settings_field_value_db_column',
							'default'  => '',
							'type'     => 'select',
							'class'    => 'ur-enhanced-select',
							'css'      => 'min-width: 350px;',
							'row_class'=> get_option('user_registration_profile_connect_settings_table_selection','usermeta_table') !== 'external_table' ? 'ur-default-hide' :'',
							'desc_tip' => true,
							'options'  => user_registration_get_columns_by_table( get_option('user_registration_profile_connect_settings_db_table',0) )
						),
					),
				),
			),
		)
	);
}
	}

endif;

return new User_Registration_Settings_Profile_Connect();
