<?php
/**
 * URWC_REST_API
 *
 * API Handler
 *
 * @class    URWC_REST_API
 * @version  xx.xx.xx
 * @package  UserRegistrationWooCommerce/Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * URWC_REST_API Class
 */
class URWC_REST_API {

	/**
	 * REST API classes and endpoints.
	 *
	 * @since xx.xx.xx
	 *
	 * @var array
	 */
	protected static $rest_classes = array();

	/**
	 * Hook into WordPress ready to init the REST API as needed.
	 *
	 * @since xx.xx.xx
	 */
	public static function init() {
		include __DIR__ . '/controllers/class-urwc-sync-fields-blocks.php';

		add_action( 'rest_api_init', array( __CLASS__, 'register_rest_routes' ) );
	}

	/**
	 * Register REST API routes.
	 *
	 * @since xx.xx.xx
	 */
	public static function register_rest_routes() {
		foreach ( self::get_rest_classes() as $rest_namespace => $classes ) {
			foreach ( $classes as $class_name ) {
				self::$rest_classes[ $rest_namespace ][ $class_name ] = new $class_name();
				self::$rest_classes[ $rest_namespace ][ $class_name ]->register_routes();
			}
		}
	}

	/**
	 * Get API Classes - new classes should be registered here.
	 *
	 * @since 3.2.0
	 *
	 * @return array List of Classes.
	 */
	protected static function get_rest_classes() {
		/**
		 * Filters rest API controller classes.
		 *
		 * @since xx.xx.xx
		 *
		 * @param array $rest_routes API namespace to API classes index array.
		 */
		return apply_filters(
			'urwc_rest_api_get_rest_namespaces',
			array(
				'urwc' => self::get_v1_rest_classes(),
			)
		);
	}

	/**
	 * List of classes.
	 *
	 * @since xx.xx.xx
	 * @static
	 *
	 * @return array
	 */
	protected static function get_v1_rest_classes() {
		return array(
			'sync-fields-blocks' => 'URWC_SYNC_FIELDS_BLOCK',
		);
	}
}

URWC_REST_API::init();
