<?php
$checkout_form_id        = get_option( 'user_registration_woocommerce_settings_form', 0 );
$checkout_sync           = ur_string_to_bool( get_option( 'user_registration_woocommrece_settings_sync_checkout', false ) );
$checkout_sync_logged_in = ur_string_to_bool( get_option( 'user_registration_woocommrece_settings_sync_checkout_logged_in', false ) );
$checkout_form_fields    = get_option( 'user_registration_woocommerce_checkout_fields', array() );

if ( 0 < $checkout_form_id && $checkout_sync && 0 < count( $checkout_form_fields ) && ! is_user_logged_in() ) {
	$mapped_checkout_form_fields = map_checkout_form_fields( $checkout_form_fields, $checkout_form_id );
	// Enqueue Faltpickr.
	$has_date = ur_has_flatpickr_field( $checkout_form_id );
	wp_enqueue_script( 'user-registration' );
	$form_data_array = ( $checkout_form_id ) ? UR()->form->get_form( $checkout_form_id, array( 'content_only' => true ) ) : array();

	do_action( 'user_registration_enqueue_scripts', $form_data_array, $checkout_form_id );

	if ( true === $has_date ) {
		wp_enqueue_style( 'flatpickr' );
		wp_enqueue_script( 'flatpickr' );
	}

	$profile = urwc_get_form_fields( $checkout_form_id );

	echo '<div class="user-registration ur-frontend-form urwc-form" data-form-id="' . esc_attr( $checkout_form_id ) . '">';
	echo '<div class="ur-form-row">';
	echo '<div class="ur-form-grid">';
	foreach ( $profile as $profile_key => $profile_field ) {
		$key = str_replace( 'user_registration_', '', $profile_key );

		if ( in_array( $profile_key, $mapped_checkout_form_fields, true ) ) {
			$profile_field['input_class'] = array( 'urwc-field-input' );
			$cl_html                      = '';

			if ( isset( $profile_field['enable_conditional_logic'] ) && true === $profile_field['enable_conditional_logic'] ) {
				$cl_map  = isset( $profile_field['cl_map'] ) ? $profile_field['cl_map'] : '';
				$cl_html = sprintf( 'data-conditional-logic-enabled="yes" data-conditional-logic-map="%s"', esc_attr( $cl_map ) );
			}

			echo '<div data-field-id="' . $key . '" class="ur-field-item field-' . $profile_field['field_key'] . ' "' . $cl_html . '>';
			user_registration_form_field( $profile_key, $profile_field, ! empty( $_POST[ $profile_key ] ) ? ur_clean( $_POST[ $profile_key ] ) : '' );
			echo '</div>';
		}
	}
	echo '<input type="hidden" id="urcl_hide_fields" name="urcl_hide_fields" value="[]">';
	echo '</div>';
	echo '</div>';
	echo '</div>';
}
