const path = require("path");
const CopyPlugin = require("copy-webpack-plugin");
const WooCommerceDependencyExtractionWebpackPlugin = require( '@woocommerce/dependency-extraction-webpack-plugin' );
const isProd = process.env.NODE_ENV === 'production';

module.exports = (env, argv) => {

	return {
		entry: {
			blocks: "./src/blocks/index.js",
			'urwc-block-frontend': "./src/blocks/blocks/checkout-sync-field/frontend.js",
		},
		output: {
			path: path.resolve(__dirname + "/chunks"),
			publicPath: "/",
			filename: "[name].js",
		},
		devtool: isProd ? false : "source-map",
		resolve: {
			extensions: [".js", ".jsx", ".json"],
		},
		module: {
			rules: [
				{
					test: /\.(js|jsx)$/,
					exclude: /node_modules/,
					use: ["babel-loader", "eslint-loader"],
				},
				{
					test: /\.s[ac]ss$/i,
					use: [
						// Creates `style` nodes from JS strings
						"style-loader",
						// Translates CSS into CommonJS
						"css-loader",
						// Compiles Sass to CSS
						"sass-loader",
					],
				},
				{
					test: /\.(gif|webp)$/i,
					use: "url-loader",
				},
				{
					test: /\.(png|svg|jpg|jpeg)$/i,
					use: [
						{
							loader: "file-loader",
						},
					],
				},
			],
		},
		plugins: [
			new CopyPlugin({
				patterns: [
					{
						from: "src/blocks/**/block.json",
						to({ absoluteFilename }) {
							return path.resolve(
								__dirname,
								"chunks",
								path.basename(path.dirname(absoluteFilename)),
								"block.json",
							);
						},
					},
				],
			}),
			new WooCommerceDependencyExtractionWebpackPlugin(),
		],
		externals: {
			"@wordpress/blocks": ["wp", "blocks"],
			"@wordpress/components": ["wp", "components"],
			"@wordpress/block-editor": ["wp", "blockEditor"],
			"@wordpress/server-side-render": ["wp", "serverSideRender"],
			'@woocommerce/settings': ['wc', 'wcSettings'],
			'@woocommerce/blocks-registry':['wc', 'wcBlocksRegistry'],
			'@woocommerce/blocks-checkout':['wc', 'blocksCheckout'],
			react: ["React"],
		},
	};
};
